/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.te;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

@FunctionalInterface
public interface ICap {
    @Nonnull
    public static final Object DENY = new Object();
    public static final Object NEXT = null;

    public Object getCapability(@Nonnull Capability<?> var1, @Nullable EnumFacing var2);

    @Nonnull
    public static Function<EnumFacing, Object> facedOnly(@Nonnull NNFunction func) {
        return facing -> facing != null ? func.apply((EnumFacing)facing) : DENY;
    }

    public static class List {
        private Map<Capability<?>, NNList<Function<EnumFacing, Object>>> primaries;
        private final NNList<ICap> secondaries = new NNList();

        public List(ICap ... fillWith) {
            this.secondaries.addAll((Object[])fillWith);
        }

        public List(Capability<?> capability, @Nonnull Function<EnumFacing, Object> func) {
            this.add(capability, func);
        }

        public void add(ICap cap) {
            this.secondaries.add(0, (Object)cap);
        }

        public void add(Capability<?> capability, @Nonnull Function<EnumFacing, Object> func) {
            if (capability != null) {
                this.getList(capability).add(0, func);
            }
        }

        private NNList<Function<EnumFacing, Object>> getList(Capability<?> capability) {
            this.primaries = (Map)NullHelper.first(this.primaries, (Supplier[])new Supplier[]{IdentityHashMap::new});
            return this.primaries.computeIfAbsent(capability, unused -> new NNList());
        }

        public <T> T first(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
            Object t;
            for (Function cap : this.getList(capability)) {
                t = cap.apply(facingIn);
                if (t == NEXT) continue;
                return (T)(t != DENY ? t : null);
            }
            for (ICap iCap : this.secondaries) {
                t = iCap.getCapability(capability, facingIn);
                if (t == NEXT) continue;
                return (T)(t != DENY ? t : null);
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface NNFunction {
        public Object apply(@Nonnull EnumFacing var1);
    }
}

