/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.invpanel.database;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import crazypants.enderio.base.invpanel.database.SlotKey;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public abstract class AbstractInventory {
    static final SlotKey[] NO_SLOTS = new SlotKey[0];
    protected SlotKey[] slotKeys = NO_SLOTS;
    protected long nextScan = -1L;
    protected boolean taggedForScanning = false;
    protected float taggingbias = 0.0f;
    protected boolean inScan = false;

    protected void markForScanning() {
        this.taggedForScanning = true;
    }

    public void markForScanning(@Nonnull BlockPos pos) {
    }

    public boolean shouldBeScannedNow(long now) {
        return this.taggedForScanning || this.nextScan <= now;
    }

    public void markScanned() {
        this.nextScan = EnderIO.proxy.getServerTickCount() + (long)MathHelper.func_76125_a((int)(1 + (this.slotKeys.length + 8) / 9), (int)30, (int)1200);
        if (this.taggingbias > 50.0f) {
            this.nextScan += 2400L;
        } else if (this.taggingbias > 5.0f) {
            this.nextScan += 300L;
        }
        this.taggedForScanning = false;
        this.inScan = false;
    }

    private void onChangeFound() {
        if (!this.inScan) {
            this.inScan = true;
            this.taggingbias = this.taggedForScanning ? (this.taggingbias += 1.0f) : (this.taggingbias *= 0.5f);
        }
    }

    protected void setEmpty(@Nonnull IInventoryDatabaseServer db) {
        if (this.slotKeys.length != 0) {
            this.reset(db, 0);
        }
    }

    protected void reset(@Nonnull IInventoryDatabaseServer db, int count) {
        for (SlotKey slotKey : this.slotKeys) {
            if (slotKey == null) continue;
            slotKey.remove(db);
        }
        this.slotKeys = new SlotKey[count];
    }

    protected void updateSlot(@Nonnull IInventoryDatabaseServer db, int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            this.emptySlot(db, slot);
        } else {
            this.updateSlot(db, slot, stack, stack.func_190916_E());
        }
    }

    protected void updateSlot(@Nonnull IInventoryDatabaseServer db, int slot, @Nonnull ItemStack stack, int count) {
        SlotKey slotKey = this.slotKeys[slot];
        IServerItemEntry current = slotKey != null ? slotKey.item : null;
        IServerItemEntry key = db.lookupItem(stack, current, true);
        if (key != current) {
            this.onChangeFound();
            this.updateSlotKey(db, slot, slotKey, key, count);
        } else if (slotKey != null && slotKey.count != count) {
            this.onChangeFound();
            slotKey.count = count;
            db.entryChanged(current);
        }
    }

    protected void emptySlot(@Nonnull IInventoryDatabaseServer db, int slot) {
        SlotKey slotKey = this.slotKeys[slot];
        if (slotKey != null) {
            this.onChangeFound();
            slotKey.remove(db);
            this.slotKeys[slot] = null;
        }
    }

    private void updateSlotKey(@Nonnull IInventoryDatabaseServer db, int slot, SlotKey slotKey, IServerItemEntry key, int count) {
        if (slotKey != null) {
            slotKey.remove(db);
            slotKey = null;
        }
        if (key != null) {
            slotKey = new SlotKey(this, slot, key, count);
            key.addSlot(slotKey);
            db.entryChanged(key);
        }
        this.slotKeys[slot] = slotKey;
    }

    protected void updateCount(@Nonnull IInventoryDatabaseServer db, int slot, IServerItemEntry entry, int count) {
        SlotKey slotKey = this.slotKeys[slot];
        if (slotKey != null && slotKey.count != count && slotKey.item == entry) {
            if (count == 0) {
                slotKey.remove(db);
                this.slotKeys[slot] = null;
            } else {
                slotKey.count = count;
                db.entryChanged(slotKey.item);
            }
        }
    }

    public abstract int scanInventory(@Nonnull IInventoryDatabaseServer var1);

    public abstract int extractItem(@Nonnull IInventoryDatabaseServer var1, IServerItemEntry var2, int var3, int var4);
}

