/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.PacketDarkSteelPowerUse;
import crazypants.enderio.base.handler.darksteel.PacketDarkSteelSFX;
import crazypants.enderio.base.handler.darksteel.StateController;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.integration.top.TheOneProbeUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.jump.JumpUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.nightvision.NightVisionUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundDetectorUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.stepassist.StepAssistUpgrade;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovementInput;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio")
public class DarkSteelController {
    @Nonnull
    private static final NNList<EntityEquipmentSlot> SLOTS = NNList.of(EntityEquipmentSlot.class);
    private static ThreadLocal<Data> DATA = new ThreadLocal<Data>(){

        @Override
        protected Data initialValue() {
            return new Data();
        }
    };
    private static final float MAGIC_STEP_HEIGHT = 1.0023f;
    private static int stepHeightWarner = 0;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!(event.phase != TickEvent.Phase.START || event.player.func_175149_v() || event.player instanceof EntityOtherPlayerMP || event.player instanceof FakePlayer)) {
            DarkSteelController.doPlayerTick(event.player);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public static void onPlayerTickServer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.func_175149_v() && !(event.player instanceof FakePlayer)) {
            DarkSteelController.doPlayerTick(event.player);
        }
    }

    private static void doPlayerTick(@Nonnull EntityPlayer player) {
        DarkSteelController.updateStepHeight(player);
        SLOTS.apply(slot -> {
            ItemStack stack = player.func_184582_a(slot);
            if (stack.func_77973_b() instanceof IDarkSteelItem) {
                for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                    if (!upgrade.hasUpgrade(stack)) continue;
                    upgrade.onPlayerTick(stack, (IDarkSteelItem)stack.func_77973_b(), player);
                }
            }
        });
    }

    public static boolean isGliderUpgradeEquipped(EntityPlayer player) {
        return GliderUpgrade.INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.CHEST));
    }

    public static boolean isElytraUpgradeEquipped(EntityPlayer player) {
        return DarkSteelController.isElytraUpgradeEquipped(player.func_184582_a(EntityEquipmentSlot.CHEST));
    }

    public static boolean isElytraUpgradeEquipped(@Nonnull ItemStack chestPlate) {
        return ElytraUpgrade.INSTANCE.hasUpgrade(chestPlate);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        int energyStored;
        ItemStack boots;
        float distance = event.getDistance();
        if (distance > 3.0f && (boots = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET)).func_77973_b() instanceof IDarkSteelItem && (energyStored = EnergyUpgradeManager.getEnergyStored(boots)) > 0) {
            float toMitigate = distance - 3.0f;
            int energyCost = (int)Math.min((double)energyStored, Math.ceil(toMitigate * (float)((Integer)DarkSteelConfig.fallDistanceCost.get()).intValue()));
            float mitigated = (float)energyCost / (float)((Integer)DarkSteelConfig.fallDistanceCost.get()).intValue();
            if (!event.getEntity().field_70170_p.field_72995_K) {
                EnergyUpgradeManager.extractEnergy(boots, (IDarkSteelItem)boots.func_77973_b(), energyCost, false);
            }
            if (mitigated < toMitigate) {
                event.setDistance(distance - mitigated);
            } else {
                event.setCanceled(true);
            }
        }
    }

    private static void updateStepHeight(EntityPlayer player) {
        if (!player.func_70093_af() && StepAssistUpgrade.isEquipped(player) && StateController.isActive(player, StepAssistUpgrade.INSTANCE)) {
            if (player.field_70138_W < 1.0023f) {
                if (Loader.isModLoaded((String)"clienttweaks") && ++stepHeightWarner > 20) {
                    player.func_146105_b((ITextComponent)Lang.GUI_STEP_ASSIST_UNAVAILABLE.toChatServer(), true);
                    stepHeightWarner = -100;
                }
                player.field_70138_W = 1.0023f;
            } else if (stepHeightWarner > 0) {
                --stepHeightWarner;
            }
        } else if (player.field_70138_W == 1.0023f) {
            player.field_70138_W = 0.6f;
            stepHeightWarner = 0;
        }
    }

    public static void usePlayerEnergy(EntityPlayer player, EntityEquipmentSlot armorSlot, int cost) {
        if (cost == 0) {
            return;
        }
        int remaining = cost;
        if (((Boolean)DarkSteelConfig.armorDrainPowerFromInventory.get()).booleanValue()) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                int used;
                IEnergyStorage cap = PowerHandlerUtil.getCapability((ItemStack)NullHelper.first((Object[])new ItemStack[]{stack, Prep.getEmpty()}));
                if (cap == null || !cap.canExtract() || (remaining -= (used = cap.extractEnergy(remaining, false))) > 0) continue;
                return;
            }
        }
        if (armorSlot != null && remaining > 0) {
            ItemStack stack = player.func_184582_a(armorSlot);
            EnergyUpgradeManager.extractEnergy(stack, remaining, false);
        }
    }

    public static int getPlayerEnergy(EntityPlayer player, EntityEquipmentSlot slot) {
        int result = 0;
        if (((Boolean)DarkSteelConfig.armorDrainPowerFromInventory.get()).booleanValue()) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                IEnergyStorage cap = PowerHandlerUtil.getCapability((ItemStack)NullHelper.first((Object[])new ItemStack[]{stack, Prep.getEmpty()}));
                if (cap == null || !cap.canExtract()) continue;
                result += cap.extractEnergy(Integer.MAX_VALUE, true);
            }
        }
        if (slot != null) {
            ItemStack stack = player.func_184582_a(slot);
            result = EnergyUpgradeManager.getEnergyStored(stack);
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (NullHelper.untrust((Object)player) == null) {
            return;
        }
        if (NullHelper.untrust((Object)player.field_71158_b) == null) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            DATA.get().jumpPre = player.field_71158_b.field_78901_c;
            return;
        }
        DarkSteelController.updateNightvision((EntityPlayer)player);
        if (player.field_71075_bZ.field_75100_b) {
            return;
        }
        MovementInput input = player.field_71158_b;
        boolean jumpHandled = false;
        if (input.field_78901_c && (!DATA.get().wasJumping || DATA.get().ticksSinceLastJump > 5)) {
            jumpHandled = DarkSteelController.doJump(player);
        }
        if (!jumpHandled && input.field_78901_c && !DATA.get().jumpPre && !player.field_70122_E && player.field_70181_x < 0.0 && !player.field_71075_bZ.field_75100_b && DarkSteelController.isElytraUpgradeEquipped((EntityPlayer)player) && !StateController.isActive((EntityPlayer)player, ElytraUpgrade.INSTANCE)) {
            StateController.setActive((EntityPlayer)player, ElytraUpgrade.INSTANCE, true);
        }
        DATA.get().wasJumping = !player.field_70122_E;
        if (!DATA.get().wasJumping) {
            DATA.get().jumpCount = 0;
        }
        DATA.get().ticksSinceLastJump++;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean doJump(@Nonnull EntityPlayerSP player) {
        if (!StateController.isActive((EntityPlayer)player, JumpUpgrade.JUMP_ONE)) {
            return false;
        }
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        JumpUpgrade jumpUpgrade = JumpUpgrade.loadAnyFromItem(boots);
        if (jumpUpgrade == null) {
            return false;
        }
        boolean autoJump = Minecraft.func_71410_x().field_71474_y.func_74308_b(GameSettings.Options.AUTO_JUMP);
        if (autoJump && DATA.get().jumpCount <= 0) {
            DATA.get().jumpCount++;
            return false;
        }
        int autoJumpOffset = autoJump ? 1 : 0;
        int requiredPower = (Integer)DarkSteelConfig.bootsJumpPowerCost.get() * (int)Math.pow(DATA.get().jumpCount + 1 - autoJumpOffset, 2.5);
        int availablePower = DarkSteelController.getPlayerEnergy((EntityPlayer)player, EntityEquipmentSlot.FEET);
        int maxJumps = jumpUpgrade.getLevel() + autoJumpOffset;
        if (availablePower > 0 && requiredPower <= availablePower && DATA.get().jumpCount < maxJumps) {
            DATA.get().jumpCount++;
            player.field_70181_x += 0.15 * (Double)DarkSteelConfig.darkSteelBootsJumpModifier.get() * (double)(DATA.get().jumpCount - autoJumpOffset);
            DATA.get().ticksSinceLastJump = 0;
            DarkSteelController.usePlayerEnergy((EntityPlayer)player, EntityEquipmentSlot.FEET, requiredPower);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelPowerUse(requiredPower, EntityEquipmentSlot.FEET));
            jumpUpgrade.doMultiplayerSFX((EntityPlayer)player);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelSFX(jumpUpgrade, (EntityPlayer)player));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateNightvision(@Nonnull EntityPlayer player) {
        if (StateController.isActive(player, NightVisionUpgrade.INSTANCE)) {
            if (DarkSteelController.isNightVisionUpgradeEquipped(player)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 0, true, true));
                DATA.get().wasNightvisionActive = true;
                return;
            }
            StateController.setActive(player, NightVisionUpgrade.INSTANCE, false);
        }
        if (DATA.get().wasNightvisionActive) {
            player.func_184589_d(MobEffects.field_76439_r);
            DATA.get().wasNightvisionActive = false;
        }
    }

    public static boolean isNightVisionUpgradeEquipped(@Nonnull EntityPlayer player) {
        return NightVisionUpgrade.INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD));
    }

    public static boolean isTopUpgradeEquipped(@Nonnull EntityPlayer player) {
        return TheOneProbeUpgrade.INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD));
    }

    public static void setTopActive(@Nonnull EntityPlayer player, boolean active) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (active) {
            ItemUtil.getOrCreateNBT((ItemStack)helmet).func_74768_a("theoneprobe", 1);
        } else {
            ItemUtil.getOrCreateNBT((ItemStack)helmet).func_82580_o("theoneprobe");
        }
    }

    public static boolean isTopActive(@Nonnull EntityPlayer player) {
        return ItemUtil.getOrCreateNBT((ItemStack)player.func_184582_a(EntityEquipmentSlot.HEAD)).func_74764_b("theoneprobe");
    }

    public static boolean isSoundDetectorUpgradeEquipped(EntityPlayer player) {
        return SoundDetectorUpgrade.INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD));
    }

    private static class Data {
        private boolean jumpPre;
        private boolean wasJumping;
        private int jumpCount;
        private int ticksSinceLastJump;
        private boolean wasNightvisionActive = false;

        private Data() {
        }
    }
}

