/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.redstone;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.redstone.signals.BundledSignal;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.filter.redstone.IOutputSignalFilter;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ToggleOutputSignalFilter
implements IOutputSignalFilter {
    private boolean active = false;
    private boolean deactivated = true;

    @Override
    @Nonnull
    public CombinedSignal apply(@Nonnull DyeColor color, @Nonnull BundledSignal bundledSignal) {
        CombinedSignal signal = bundledSignal.getSignal(color);
        if (signal.getStrength() > CombinedSignal.NONE.getStrength() && this.deactivated) {
            this.active = !this.active;
            this.deactivated = false;
        }
        if (signal.getStrength() == CombinedSignal.NONE.getStrength()) {
            this.deactivated = true;
        }
        return this.active ? CombinedSignal.MAX : CombinedSignal.NONE;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound t = nbtRoot.func_74775_l("toggleActive");
        this.active = t.func_74767_n("active");
        NBTTagCompound d = nbtRoot.func_74775_l("deactivated");
        this.deactivated = d.func_74767_n("deactivated");
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74757_a("active", this.active);
        nbtRoot.func_74782_a("toggleActive", (NBTBase)t);
        NBTTagCompound d = new NBTTagCompound();
        d.func_74757_a("deactivated", this.deactivated);
        nbtRoot.func_74782_a("deactivated", (NBTBase)d);
    }

    @Override
    public boolean hasGui() {
        return false;
    }
}

