/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.FluidHiding;
import crazypants.enderio.base.config.recipes.xml.ItemHiding;
import crazypants.enderio.base.recipe.RecipeLevel;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Hiding
extends AbstractConditional {
    private final NNList<IHidingElement> elements = new NNList();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.elements.isEmpty()) {
                throw new InvalidRecipeConfigException("Missing <item> or <fluid>");
            }
            this.valid = true;
            for (IHidingElement element : this.elements) {
                this.valid = this.valid && element.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <hiding>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (IHidingElement element : this.elements) {
            element.enforceValidity();
        }
    }

    @Override
    public void register(@Nonnull String recipeName, @Nonnull RecipeLevel recipeLevel) {
        if (this.isValid() && this.isActive()) {
            for (IHidingElement element : this.elements) {
                element.register(recipeName);
            }
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            this.elements.add((Object)factory.read(new ItemHiding(), startElement));
            return true;
        }
        if ("fluid".equals(name)) {
            this.elements.add((Object)factory.read(new FluidHiding(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    public static interface IHidingElement
    extends IRecipeConfigElement {
        public void register(String var1);
    }
}

