/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import javax.annotation.Nonnull;

public enum ConnectionMode {
    IN_OUT("gui.conduit.io_mode.in_out"),
    INPUT("gui.conduit.io_mode.input"),
    OUTPUT("gui.conduit.io_mode.output"),
    DISABLED("gui.conduit.io_mode.disabled"),
    NOT_SET("gui.conduit.io_mode.not_set");

    @Nonnull
    private final String unlocalisedName;

    private ConnectionMode(String unlocalisedName) {
        this.unlocalisedName = unlocalisedName;
    }

    @Nonnull
    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @Nonnull
    public static ConnectionMode getNext(@Nonnull ConnectionMode mode) {
        int ord = mode.ordinal() + 1;
        if (ord >= ConnectionMode.values().length) {
            ord = 0;
        }
        return (ConnectionMode)((Object)NullHelper.first((Object[])new ConnectionMode[]{ConnectionMode.values()[ord], NOT_SET}));
    }

    @Nonnull
    public static ConnectionMode getPrevious(@Nonnull ConnectionMode mode) {
        int ord = mode.ordinal() - 1;
        if (ord < 0) {
            ord = ConnectionMode.values().length - 1;
        }
        return (ConnectionMode)((Object)NullHelper.first((Object[])new ConnectionMode[]{ConnectionMode.values()[ord], NOT_SET}));
    }

    public boolean acceptsInput() {
        return this == IN_OUT || this == INPUT;
    }

    public boolean acceptsOutput() {
        return this == IN_OUT || this == OUTPUT;
    }

    public boolean isActive() {
        return this != DISABLED;
    }

    @Nonnull
    public String getLocalisedName() {
        return EnderIO.lang.localize(this.unlocalisedName);
    }

    static {
        for (ConnectionMode lang : ConnectionMode.values()) {
            if (EnderIO.lang.canLocalize(lang.unlocalisedName)) continue;
            Log.error("Missing translation for '" + lang.unlocalisedName);
        }
    }
}

