/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.capacitor.Scaler;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.PacketCapacitorSync;
import crazypants.enderio.base.capacitor.ScalerFactory;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.network.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Triple;

@Mod.EventBusSubscriber(modid="enderio")
public class CapacitorKeyRegistry {
    private static IForgeRegistry<ICapacitorKey> REGISTRY = null;
    @Nonnull
    private static final Map<ICapacitorKey, Triple<Integer, Scaler, String>> BASE = new HashMap<ICapacitorKey, Triple<Integer, Scaler, String>>();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("enderio", "capacitor")).setType(ICapacitorKey.class).setIDRange(0, 0x7FFFFFFE).create();
    }

    public static void setValue(@Nonnull ResourceLocation name, int baseValue, @Nullable Scaler scaler, @Nonnull String scalerString) {
        ICapacitorKey key = (ICapacitorKey)REGISTRY.getValue(name);
        if (key == null) {
            throw new RuntimeException("Trying to configure non-existant key " + name);
        }
        Scaler theScaler = scaler != null ? scaler : (Scaler)NullHelper.notnull((Object)ScalerFactory.fromString(scalerString), (Object[])new Object[]{"Invalid scaler '", scalerString, "'"});
        key.setBaseValue(baseValue);
        key.setScaler(theScaler);
        BASE.put(key, (Triple<Integer, Scaler, String>)Triple.of((Object)baseValue, (Object)theScaler, (Object)scalerString));
    }

    public static void validate() {
        for (ICapacitorKey key : REGISTRY.getValuesCollection()) {
            try {
                key.validate();
            }
            catch (ICapacitorKey.UnconfiguredCapKeyException e) {
                if (!((Boolean)RecipeConfig.loadCoreRecipes.get()).booleanValue()) {
                    throw new ICapacitorKey.UnconfiguredCapKeyException("Ender IO core recipe loading has been disabled in the configuration and you have failed to provide a user recipe for: " + key.getRegistryName(), e);
                }
                throw e;
            }
        }
    }

    public static void resetOverrides() {
        for (Map.Entry<ICapacitorKey, Triple<Integer, Scaler, String>> entry : BASE.entrySet()) {
            ICapacitorKey key = entry.getKey();
            Triple<Integer, Scaler, String> pair = entry.getValue();
            if (key == null || pair == null) continue;
            Integer baseValue = (Integer)pair.getLeft();
            Scaler scaler = (Scaler)pair.getMiddle();
            if (baseValue == null || scaler == null) continue;
            key.setBaseValue(baseValue);
            key.setScaler(scaler);
        }
    }

    public static void addOverride(@Nonnull ResourceLocation name, int baseValue, @Nullable String scalerString) {
        ICapacitorKey key = (ICapacitorKey)REGISTRY.getValue(name);
        if (key == null) {
            throw new RuntimeException("Trying to override non-existant key " + name);
        }
        key.setBaseValue(baseValue);
        key.setScaler((Scaler)NullHelper.notnull((Object)ScalerFactory.fromString(scalerString), (Object[])new Object[]{"Invalid scaler '", scalerString, "'"}));
    }

    public static boolean contains(@Nonnull ResourceLocation name) {
        return REGISTRY.containsKey(name);
    }

    @SubscribeEvent
    public static void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        PacketHandler.sendTo(new PacketCapacitorSync(BASE), (EntityPlayerMP)evt.player);
        Log.debug("Sending server config overrides for capacitor keys to player " + evt.player.func_70005_c_());
    }

    @SubscribeEvent
    public static void onPlayerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        CapacitorKeyRegistry.resetOverrides();
        Log.debug("Removed server config overrides for capacitor keys");
    }
}

