/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.modelloader.internal;

import com.cout970.modelloader.ModelLoaderMod;
import com.cout970.modelloader.api.IBakedModelDecorator;
import com.cout970.modelloader.api.Model;
import com.cout970.modelloader.api.ModelEntry;
import com.cout970.modelloader.api.formats.gltf.GltfModel;
import com.cout970.modelloader.api.formats.mcx.McxModel;
import com.cout970.modelloader.internal.GltfModelSerializer;
import com.cout970.modelloader.internal.McxModelSerializer;
import com.cout970.modelloader.internal.ModelManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001/B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001d\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b J'\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\"0&\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020,H\u0007J\f\u0010-\u001a\u00020.*\u00020\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/cout970/modelloader/internal/ModelManager;", "", "()V", "MISSING_TEXTURE", "Lnet/minecraft/util/ResourceLocation;", "getMISSING_TEXTURE", "()Lnet/minecraft/util/ResourceLocation;", "loadedModels", "", "Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;", "Lcom/cout970/modelloader/api/ModelEntry;", "getLoadedModels$modelloader", "()Ljava/util/Map;", "models", "", "Lcom/cout970/modelloader/internal/ModelManager$ModelRegistration;", "getModels$modelloader", "()Ljava/util/List;", "modelsToBake", "Lkotlin/Pair;", "Lnet/minecraftforge/client/model/IModel;", "texturesToRegister", "", "bake", "Lnet/minecraft/client/renderer/block/model/IBakedModel;", "model", "loadAll", "", "loadModel", "manager", "Lnet/minecraft/client/resources/IResourceManager;", "location", "loadModel$modelloader", "logTime", "R", "prefix", "", "func", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onModelBakeEvent", "event", "Lnet/minecraftforge/client/event/ModelBakeEvent;", "onTextureStart", "Lnet/minecraftforge/client/event/TextureStitchEvent$Pre;", "wrap", "Lcom/cout970/modelloader/api/Model;", "ModelRegistration", "modelloader"})
public final class ModelManager {
    @NotNull
    private static final ResourceLocation MISSING_TEXTURE;
    @NotNull
    private static final List<ModelRegistration> models;
    private static final Set<ResourceLocation> texturesToRegister;
    private static final List<Pair<ModelRegistration, IModel>> modelsToBake;
    @NotNull
    private static final Map<ModelResourceLocation, ModelEntry> loadedModels;
    public static final ModelManager INSTANCE;

    @NotNull
    public final ResourceLocation getMISSING_TEXTURE() {
        return MISSING_TEXTURE;
    }

    @NotNull
    public final List<ModelRegistration> getModels$modelloader() {
        return models;
    }

    @NotNull
    public final Map<ModelResourceLocation, ModelEntry> getLoadedModels$modelloader() {
        return loadedModels;
    }

    @SubscribeEvent
    public final void onTextureStart(@NotNull TextureStitchEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.logTime("Loading models (multithread: " + ModelLoaderMod.INSTANCE.getUseMultiThreading$modelloader() + ')', onTextureStart.1.INSTANCE);
        this.logTime("Registering textures", (Function0)new Function0<Unit>(event){
            final /* synthetic */ TextureStitchEvent.Pre $event;

            public final void invoke() {
                this.$event.getMap().func_174942_a(ModelManager.INSTANCE.getMISSING_TEXTURE());
                Iterable $receiver$iv = ModelManager.access$getTexturesToRegister$p(ModelManager.INSTANCE);
                for (T element$iv : $receiver$iv) {
                    ResourceLocation it = (ResourceLocation)element$iv;
                    this.$event.getMap().func_174942_a(it);
                }
                ModelManager.access$getTexturesToRegister$p(ModelManager.INSTANCE).clear();
            }
            {
                this.$event = pre;
                super(0);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onModelBakeEvent(@NotNull ModelBakeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.logTime("Baking models (multithread: " + ModelLoaderMod.INSTANCE.getUseMultiThreading$modelloader() + ')', (Function0)new Function0<Unit>(event){
            final /* synthetic */ ModelBakeEvent $event;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                ModelRegistration reg;
                void $receiver$iv$iv;
                Pair pair;
                ModelRegistration id;
                Iterable<Pair> iterable;
                Iterable<Pair> destination$iv$iv;
                List list;
                if (ModelLoaderMod.INSTANCE.getUseMultiThreading$modelloader()) {
                    List list2 = CollectionsKt.toList((Iterable)ModelManager.access$getModelsToBake$p(ModelManager.INSTANCE)).parallelStream().map(onModelBakeEvent.bakedModels.1.INSTANCE).collect(Collectors.<T>toList());
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"modelsToBake\n           \u2026lect(Collectors.toList())");
                    list = list2;
                } else {
                    void $receiver$iv$iv2;
                    Iterable $receiver$iv = ModelManager.access$getModelsToBake$p(ModelManager.INSTANCE);
                    Iterable iterable2 = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        void $id_model;
                        Pair pair2 = (Pair)item$iv$iv;
                        iterable = destination$iv$iv;
                        id = (ModelRegistration)$id_model.component1();
                        IModel model = (IModel)$id_model.component2();
                        pair = TuplesKt.to((Object)id, (Object)ModelManager.access$bake(ModelManager.INSTANCE, model));
                        iterable.add(pair);
                    }
                    list = (List)destination$iv$iv;
                }
                List bakedModels2 = list;
                Iterable $receiver$iv = ModelManager.access$getModelsToBake$p(ModelManager.INSTANCE);
                destination$iv$iv = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (E item$iv$iv : $receiver$iv$iv) {
                    void it;
                    id = (Pair)item$iv$iv;
                    iterable = destination$iv$iv2;
                    pair = TuplesKt.to((Object)((ModelRegistration)it.getFirst()).getModelId(), (Object)it.getSecond());
                    iterable.add((Pair)pair);
                }
                Map idToModel = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                $receiver$iv = bakedModels2;
                for (T element$iv : $receiver$iv) {
                    Pair $reg_baked = (Pair)element$iv;
                    reg = (ModelRegistration)$reg_baked.component1();
                    IBakedModel baked = (IBakedModel)$reg_baked.component2();
                    Map<ModelResourceLocation, ModelEntry> $i$a$1$map = ModelManager.INSTANCE.getLoadedModels$modelloader();
                    ModelResourceLocation $i$f$mapTo = reg.getModelId();
                    V v = idToModel.get(reg.getModelId());
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    ModelEntry $i$f$map = new ModelEntry(baked, ModelManager.access$wrap(ModelManager.INSTANCE, (IModel)v));
                    $i$a$1$map.put($i$f$mapTo, $i$f$map);
                }
                ModelManager.access$getModelsToBake$p(ModelManager.INSTANCE).clear();
                $receiver$iv = bakedModels2;
                for (T element$iv : $receiver$iv) {
                    Pair $reg_bakedModel = (Pair)element$iv;
                    reg = (ModelRegistration)$reg_bakedModel.component1();
                    IBakedModel bakedModel = (IBakedModel)$reg_bakedModel.component2();
                    IBakedModelDecorator iBakedModelDecorator = reg.getDecorator();
                    if (iBakedModelDecorator == null || (iBakedModelDecorator = iBakedModelDecorator.decorate(bakedModel, reg.getModelId())) == null) {
                        iBakedModelDecorator = bakedModel;
                    }
                    IBakedModelDecorator finalModel = iBakedModelDecorator;
                    this.$event.getModelRegistry().func_82595_a((Object)reg.getModelId(), (Object)finalModel);
                }
            }
            {
                this.$event = modelBakeEvent;
                super(0);
            }
        });
    }

    private final void loadAll() {
        Map map2;
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        IResourceManager manager = minecraft.func_110442_L();
        texturesToRegister.clear();
        modelsToBake.clear();
        loadedModels.clear();
        if (ModelLoaderMod.INSTANCE.getUseMultiThreading$modelloader()) {
            List list = models.parallelStream().map(loadAll.cache.1.INSTANCE).distinct().map(new Function<T, R>(manager){
                final /* synthetic */ IResourceManager $manager;

                @NotNull
                public final Pair<ResourceLocation, IModel> apply(ResourceLocation it) {
                    IResourceManager iResourceManager = this.$manager;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iResourceManager, (String)"manager");
                    ResourceLocation resourceLocation = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"it");
                    return TuplesKt.to((Object)it, (Object)ModelManager.INSTANCE.loadModel$modelloader(iResourceManager, resourceLocation));
                }
                {
                    this.$manager = iResourceManager;
                }
            }).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"models.parallelStream()\n\u2026lect(Collectors.toList())");
            map2 = MapsKt.toMap((Iterable)list);
        } else {
            map2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)models), (Function1)loadAll.cache.3.INSTANCE)), (Function1)((Function1)new Function1<ResourceLocation, Pair<? extends ResourceLocation, ? extends IModel>>(manager){
                final /* synthetic */ IResourceManager $manager;

                @NotNull
                public final Pair<ResourceLocation, IModel> invoke(@NotNull ResourceLocation it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    IResourceManager iResourceManager = this.$manager;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iResourceManager, (String)"manager");
                    return TuplesKt.to((Object)it, (Object)ModelManager.INSTANCE.loadModel$modelloader(iResourceManager, it));
                }
                {
                    this.$manager = iResourceManager;
                    super(1);
                }
            })));
        }
        Map cache2 = map2;
        Iterable $receiver$iv = models;
        for (Object element$iv : $receiver$iv) {
            ModelResourceLocation modelResourceLocation;
            Object object;
            ModelRegistration reg = (ModelRegistration)element$iv;
            Object v = cache2.get(reg.getModelLocation());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            IModel model = (IModel)v;
            if (reg.getBake()) {
                Collection collection = model.getTextures();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"model.textures");
                texturesToRegister.addAll(collection);
                object = modelsToBake;
                modelResourceLocation = TuplesKt.to((Object)reg, (Object)model);
                object.add(modelResourceLocation);
                continue;
            }
            object = loadedModels;
            modelResourceLocation = reg.getModelId();
            ModelEntry modelEntry = new ModelEntry(null, INSTANCE.wrap(model));
            object.put(modelResourceLocation, modelEntry);
        }
    }

    @NotNull
    public final IModel loadModel$modelloader(@NotNull IResourceManager manager, @NotNull ResourceLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        try {
            IModel iModel;
            String extension;
            IResource iResource = manager.func_110536_a(location);
            Intrinsics.checkExpressionValueIsNotNull((Object)iResource, (String)"manager.getResource(location)");
            InputStream resource = iResource.func_110527_b();
            String string = location.func_110623_a();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"location.resourcePath");
            switch (extension = StringsKt.substringAfterLast((String)string, (char)'.', (String)"")) {
                case "obj": {
                    IModel iModel2 = OBJLoader.INSTANCE.loadModel(location);
                    iModel = iModel2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iModel2, (String)"OBJLoader.INSTANCE.loadModel(location)");
                    break;
                }
                case "gltf": {
                    InputStream inputStream = resource;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"resource");
                    iModel = GltfModelSerializer.INSTANCE.load(manager, location, inputStream);
                    break;
                }
                default: {
                    InputStream inputStream = resource;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"resource");
                    iModel = McxModelSerializer.INSTANCE.load(inputStream);
                }
            }
            return iModel;
        }
        catch (Exception e) {
            ModelLoaderMod.INSTANCE.getLogger().error("Error reading model data for location: " + location);
            e.printStackTrace();
            IModel iModel = ModelLoaderRegistry.getMissingModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)iModel, (String)"ModelLoaderRegistry.getMissingModel()");
            return iModel;
        }
    }

    private final Model wrap(@NotNull IModel $receiver) {
        IModel iModel = $receiver;
        return iModel instanceof McxModel ? (Model)new Model.Mcx((McxModel)$receiver) : (iModel instanceof GltfModel ? (Model)new Model.Gltf((GltfModel)$receiver) : (iModel instanceof OBJModel ? (Model)new Model.Obj((OBJModel)$receiver) : (Model)Model.Missing.INSTANCE));
    }

    private final IBakedModel bake(IModel model) {
        IBakedModel iBakedModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        Intrinsics.checkExpressionValueIsNotNull((Object)iBakedModel, (String)"model.bake(TRSRTransform\u2026r.defaultTextureGetter())");
        return iBakedModel;
    }

    public final <R> R logTime(@NotNull String prefix, @NotNull Function0<? extends R> func) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        long start = System.currentTimeMillis();
        Object res = func.invoke();
        long end = System.currentTimeMillis();
        ModelLoaderMod.INSTANCE.getLogger().info("" + prefix + ' ' + (end - start) + "ms");
        return (R)res;
    }

    private ModelManager() {
    }

    static {
        ModelManager modelManager;
        INSTANCE = modelManager = new ModelManager();
        MISSING_TEXTURE = new ResourceLocation("modelloader:missing_texture");
        models = new ArrayList();
        texturesToRegister = new LinkedHashSet();
        modelsToBake = new ArrayList();
        loadedModels = new LinkedHashMap();
    }

    public static final /* synthetic */ void access$loadAll(ModelManager $this) {
        $this.loadAll();
    }

    @NotNull
    public static final /* synthetic */ Set access$getTexturesToRegister$p(ModelManager $this) {
        ModelManager modelManager = $this;
        return texturesToRegister;
    }

    @NotNull
    public static final /* synthetic */ List access$getModelsToBake$p(ModelManager $this) {
        ModelManager modelManager = $this;
        return modelsToBake;
    }

    @NotNull
    public static final /* synthetic */ IBakedModel access$bake(ModelManager $this, @NotNull IModel model) {
        return $this.bake(model);
    }

    @NotNull
    public static final /* synthetic */ Model access$wrap(ModelManager $this, @NotNull IModel $receiver) {
        return $this.wrap($receiver);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/cout970/modelloader/internal/ModelManager$ModelRegistration;", "", "modelId", "Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;", "modelLocation", "Lnet/minecraft/util/ResourceLocation;", "bake", "", "decorator", "Lcom/cout970/modelloader/api/IBakedModelDecorator;", "(Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;Lnet/minecraft/util/ResourceLocation;ZLcom/cout970/modelloader/api/IBakedModelDecorator;)V", "getBake", "()Z", "getDecorator", "()Lcom/cout970/modelloader/api/IBakedModelDecorator;", "getModelId", "()Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;", "getModelLocation", "()Lnet/minecraft/util/ResourceLocation;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "modelloader"})
    public static final class ModelRegistration {
        @NotNull
        private final ModelResourceLocation modelId;
        @NotNull
        private final ResourceLocation modelLocation;
        private final boolean bake;
        @Nullable
        private final IBakedModelDecorator decorator;

        @NotNull
        public final ModelResourceLocation getModelId() {
            return this.modelId;
        }

        @NotNull
        public final ResourceLocation getModelLocation() {
            return this.modelLocation;
        }

        public final boolean getBake() {
            return this.bake;
        }

        @Nullable
        public final IBakedModelDecorator getDecorator() {
            return this.decorator;
        }

        public ModelRegistration(@NotNull ModelResourceLocation modelId, @NotNull ResourceLocation modelLocation, boolean bake, @Nullable IBakedModelDecorator decorator) {
            Intrinsics.checkParameterIsNotNull((Object)modelId, (String)"modelId");
            Intrinsics.checkParameterIsNotNull((Object)modelLocation, (String)"modelLocation");
            this.modelId = modelId;
            this.modelLocation = modelLocation;
            this.bake = bake;
            this.decorator = decorator;
        }

        @NotNull
        public final ModelResourceLocation component1() {
            return this.modelId;
        }

        @NotNull
        public final ResourceLocation component2() {
            return this.modelLocation;
        }

        public final boolean component3() {
            return this.bake;
        }

        @Nullable
        public final IBakedModelDecorator component4() {
            return this.decorator;
        }

        @NotNull
        public final ModelRegistration copy(@NotNull ModelResourceLocation modelId, @NotNull ResourceLocation modelLocation, boolean bake, @Nullable IBakedModelDecorator decorator) {
            Intrinsics.checkParameterIsNotNull((Object)modelId, (String)"modelId");
            Intrinsics.checkParameterIsNotNull((Object)modelLocation, (String)"modelLocation");
            return new ModelRegistration(modelId, modelLocation, bake, decorator);
        }

        @NotNull
        public static /* synthetic */ ModelRegistration copy$default(ModelRegistration modelRegistration, ModelResourceLocation modelResourceLocation, ResourceLocation resourceLocation, boolean bl, IBakedModelDecorator iBakedModelDecorator, int n, Object object) {
            if ((n & 1) != 0) {
                modelResourceLocation = modelRegistration.modelId;
            }
            if ((n & 2) != 0) {
                resourceLocation = modelRegistration.modelLocation;
            }
            if ((n & 4) != 0) {
                bl = modelRegistration.bake;
            }
            if ((n & 8) != 0) {
                iBakedModelDecorator = modelRegistration.decorator;
            }
            return modelRegistration.copy(modelResourceLocation, resourceLocation, bl, iBakedModelDecorator);
        }

        public String toString() {
            return "ModelRegistration(modelId=" + this.modelId + ", modelLocation=" + this.modelLocation + ", bake=" + this.bake + ", decorator=" + this.decorator + ")";
        }

        public int hashCode() {
            ModelResourceLocation modelResourceLocation = this.modelId;
            ResourceLocation resourceLocation = this.modelLocation;
            int n = ((modelResourceLocation != null ? modelResourceLocation.hashCode() : 0) * 31 + (resourceLocation != null ? resourceLocation.hashCode() : 0)) * 31;
            int n2 = this.bake ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            IBakedModelDecorator iBakedModelDecorator = this.decorator;
            return (n + n2) * 31 + (iBakedModelDecorator != null ? iBakedModelDecorator.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModelRegistration)) break block3;
                    ModelRegistration modelRegistration = (ModelRegistration)object;
                    if (!Intrinsics.areEqual((Object)this.modelId, (Object)modelRegistration.modelId) || !Intrinsics.areEqual((Object)this.modelLocation, (Object)modelRegistration.modelLocation) || !(this.bake == modelRegistration.bake) || !Intrinsics.areEqual((Object)this.decorator, (Object)modelRegistration.decorator)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

