/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.api.m_multiblocks.m_components.m_modifiers.attribute;

import com.valkyrieofnight.um.api.attribute.AAttributeCalculator;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class AttributeAccuracy
implements IAttribute<Float> {
    public static final AttributeID ACCURACY = new AttributeID("environmentaltech", "accuracy", ACalcAccuracy.class);
    protected float level;

    public AttributeAccuracy(float level) {
        this.level = level;
    }

    public AttributeID getAttributeID() {
        return ACCURACY;
    }

    public Float getValue() {
        return Float.valueOf(this.level);
    }

    public static final class ACalcAccuracy
    extends AAttributeCalculator<AttributeAccuracy, Float, Float, Float> {
        public Float calculateFinalValue(List<IAttribute<Float>> attributes) {
            float total = 0.0f;
            for (IAttribute<Float> iAttribute : attributes) {
                total += ((Float)iAttribute.getValue()).floatValue();
            }
            return Float.valueOf(total);
        }

        public Float calculateModifiedValue(Float attributeFinalValue, Float unmodifiedValue) {
            return Float.valueOf(unmodifiedValue.floatValue() * this.getMultiplier(attributeFinalValue.floatValue()));
        }

        public float getMultiplier(float totalModificationFactor) {
            return (float)Math.pow(1.18, totalModificationFactor);
        }

        public Object readFinalValueFromNBT(NBTTagCompound nbt) {
            return Float.valueOf(nbt.func_74760_g(this.getAttribute().toString()));
        }

        public NBTTagCompound writeFinalValueToNBT(NBTTagCompound nbt, Object obj) {
            Float data = (Float)obj;
            nbt.func_74776_a(this.getAttribute().toString(), data.floatValue());
            return nbt;
        }

        public int getLargerFinalValue(Object firstFinalValue, Object secondFinalValue) {
            Float f = (Float)firstFinalValue;
            Float s = (Float)secondFinalValue;
            if (f.floatValue() > s.floatValue()) {
                return 1;
            }
            if (f.floatValue() < s.floatValue()) {
                return 2;
            }
            return 0;
        }
    }
}

