/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.network;

import io.netty.buffer.ByteBuf;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktCopyToClipboard
implements IMessage,
IMessageHandler<PktCopyToClipboard, IMessage> {
    private String strToCopy;

    public PktCopyToClipboard() {
    }

    public PktCopyToClipboard(String strToCopy) {
        this.strToCopy = strToCopy;
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        byte[] strBytes = new byte[length];
        buf.readBytes(strBytes, 0, length);
        this.strToCopy = new String(strBytes, StandardCharsets.UTF_8);
    }

    public void toBytes(ByteBuf buf) {
        byte[] str = this.strToCopy.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(str.length);
        buf.writeBytes(str);
    }

    public IMessage onMessage(PktCopyToClipboard message, MessageContext ctx) {
        this.handleCopy(message.strToCopy);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleCopy(String strToCopy) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (Desktop.isDesktopSupported()) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(strToCopy), null);
            }
        });
    }
}

