/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.PreparedRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapterAccessor;
import hellfirepvp.modularmachinery.common.crafting.command.RecipeRunnableCommand;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.JsonUtils;

public class RecipeLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(MachineRecipe.MachineRecipeContainer.class, (Object)new MachineRecipe.Deserializer()).registerTypeHierarchyAdapter(ComponentRequirement.class, (Object)new MachineRecipe.ComponentDeserializer()).registerTypeHierarchyAdapter(RecipeAdapterAccessor.class, (Object)new RecipeAdapterAccessor.Deserializer()).registerTypeHierarchyAdapter(RecipeModifier.class, (Object)new RecipeModifier.Deserializer()).registerTypeHierarchyAdapter(RecipeRunnableCommand.class, (Object)new RecipeRunnableCommand.Deserializer()).create();
    public static List<RecipeAdapterAccessor> recipeAdapters = new LinkedList<RecipeAdapterAccessor>();
    private static Map<String, Exception> failedAttempts = new HashMap<String, Exception>();
    public static String currentlyReadingPath = null;

    public static Map<FileType, List<File>> discoverDirectory(File directory) {
        HashMap<FileType, List<File>> candidates = new HashMap<FileType, List<File>>();
        for (FileType type : FileType.values()) {
            candidates.put(type, Lists.newLinkedList());
        }
        LinkedList directories = Lists.newLinkedList();
        directories.add(directory);
        while (!directories.isEmpty()) {
            File dir = (File)directories.remove(0);
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    directories.addLast(f);
                    continue;
                }
                if (FileType.ADAPTER.accepts(f.getName())) {
                    ((List)candidates.get((Object)FileType.ADAPTER)).add(f);
                    continue;
                }
                if (!FileType.RECIPE.accepts(f.getName())) continue;
                ((List)candidates.get((Object)FileType.RECIPE)).add(f);
            }
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MachineRecipe> loadRecipes(List<File> recipeCandidates, List<PreparedRecipe> preparedRecipes) {
        recipeAdapters.clear();
        ArrayList loadedRecipes = Lists.newArrayList();
        for (File f : recipeCandidates) {
            currentlyReadingPath = f.getPath();
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    MachineRecipe.MachineRecipeContainer container = (MachineRecipe.MachineRecipeContainer)JsonUtils.func_193839_a((Gson)GSON, (Reader)isr, MachineRecipe.MachineRecipeContainer.class);
                    loadedRecipes.addAll(container.getRecipes());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (isr == null) continue;
                    if (throwable != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    isr.close();
                }
            }
            catch (Exception exc) {
                failedAttempts.put(f.getPath(), exc);
            }
            finally {
                currentlyReadingPath = null;
            }
        }
        for (PreparedRecipe recipe : preparedRecipes) {
            loadedRecipes.add(RecipeLoader.convertPreparedRecipe(recipe));
        }
        return loadedRecipes;
    }

    public static List<MachineRecipe> loadAdapterRecipes(List<File> adapterCandidates) {
        ArrayList loadedRecipes = Lists.newArrayList();
        for (File f : adapterCandidates) {
            try {
                InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
                Throwable throwable = null;
                try {
                    RecipeAdapterAccessor accessor = (RecipeAdapterAccessor)JsonUtils.func_193839_a((Gson)GSON, (Reader)isr, RecipeAdapterAccessor.class);
                    List<MachineRecipe> recipes = accessor.loadRecipesForAdapter();
                    if (recipes.isEmpty()) {
                        ModularMachinery.log.warn("Adapter with name " + accessor.getAdapterKey().toString() + " didn't provide have any recipes!");
                    } else {
                        loadedRecipes.addAll(recipes);
                    }
                    recipeAdapters.add(accessor);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (isr == null) continue;
                    if (throwable != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    isr.close();
                }
            }
            catch (Exception exc) {
                failedAttempts.put(f.getPath(), exc);
            }
        }
        return loadedRecipes;
    }

    private static MachineRecipe convertPreparedRecipe(PreparedRecipe recipe) {
        MachineRecipe mr = new MachineRecipe(recipe.getFilePath(), recipe.getRecipeRegistryName(), recipe.getAssociatedMachineName(), recipe.getTotalProcessingTickTime(), recipe.getPriority());
        recipe.getComponents().forEach(mr::addRequirement);
        return mr;
    }

    public static Map<String, Exception> captureFailedAttempts() {
        Map<String, Exception> failed = failedAttempts;
        failedAttempts = new HashMap<String, Exception>();
        return failed;
    }

    public static enum FileType {
        ADAPTER,
        RECIPE;


        public boolean accepts(String fileName) {
            switch (this) {
                case ADAPTER: {
                    return fileName.endsWith(".adapter.json");
                }
            }
            return fileName.endsWith(".json");
        }
    }
}

