/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.world.gen;

import com.ancient.thaumicgadgets.world.gen.generators.WorldGenDungeon;
import com.ancient.thaumicgadgets.world.saved_data.AncientCacheSavedData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomDungeon
implements IWorldGenerator {
    public static final WorldGenDungeon ANCIENT_CACHE = new WorldGenDungeon("ancient_cache");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case -1: {
                this.generateDungeon(ANCIENT_CACHE, world, random, chunkX, chunkZ, 6, Blocks.field_150424_aL, (Block)Blocks.field_150353_l, BiomeHell.class);
            }
        }
    }

    private void generateDungeon(WorldGenerator generator, World world, Random rand, int chunkX, int chunkZ, int chance, Block botBlock, Block topBlock, Class<?> ... classes) {
        int z;
        int y;
        int x;
        BlockPos pos;
        Class<?> biome;
        ArrayList classesList = Lists.newArrayList(Arrays.asList(classes));
        if (classesList.contains(biome = world.field_73011_w.getBiomeForCoords(pos = new BlockPos(x = chunkX * 16 + rand.nextInt(15), y = WorldGenCustomDungeon.calculateGenerationHeight(world, x, z = chunkZ * 16 + rand.nextInt(15), botBlock, topBlock), z)).getClass()) && y > 5 && rand.nextInt(101) <= chance) {
            generator.func_180709_b(world, rand, pos);
            AncientCacheSavedData data = AncientCacheSavedData.get(world);
            data.addNewPos(pos.func_177981_b(2).func_177970_e(5).func_177965_g(5));
            System.out.println("Generate at: " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block botBlock, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 5) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            Block fLayer = world.func_180495_p(new BlockPos(x, y + 11, z)).func_177230_c();
            Block sLayer = world.func_180495_p(new BlockPos(x, y + 12, z)).func_177230_c();
            if (block != botBlock || fLayer != topBlock || sLayer != botBlock) continue;
            foundGround = true;
        }
        return y;
    }
}

