/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.util.handlers;

import com.ancient.thaumicgadgets.Main;
import com.ancient.thaumicgadgets.entity.ModEntity;
import com.ancient.thaumicgadgets.init.ModBlocks;
import com.ancient.thaumicgadgets.init.ModEnchantments;
import com.ancient.thaumicgadgets.init.ModItems;
import com.ancient.thaumicgadgets.init.ModSounds;
import com.ancient.thaumicgadgets.util.IHasModel;
import com.ancient.thaumicgadgets.util.handlers.GUIHandler;
import com.ancient.thaumicgadgets.util.handlers.TileEntityHandler;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistyHandler {
    public static void preInitRegistries() {
        ModSounds.registerSounds();
        ModEntity.registerEntities();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Main.instance, (IGuiHandler)new GUIHandler());
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
        TileEntityHandler.registerTileEntities();
    }

    @SubscribeEvent
    public static void onEnchantmentRegister(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModEnchantments.ECHANTMENTS.toArray(new Enchantment[0]));
    }

    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModSounds.SOUNDS.toArray(new SoundEvent[0]));
    }
}

