/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.util.handlers;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.ancient.thaumicgadgets.armour.light.ArmorLight;
import com.ancient.thaumicgadgets.armour.primal.ArmorPrimal;
import com.ancient.thaumicgadgets.armour.shade.ArmorShade;
import com.ancient.thaumicgadgets.armour.shade.ShadeBelt;
import com.ancient.thaumicgadgets.util.Reference;
import com.ancient.thaumicgadgets.util.handlers.ParticleSpawner;
import com.ancient.thaumicgadgets.util.handlers.RandomFunctions;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerFlyHandler {
    private static final ParticleSpawner ps = ParticleSpawner.INSTANCE;

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        NBTTagCompound nbt;
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayer && (nbt = (player = (EntityPlayer)event.getEntityLiving()).getEntityData()).func_74764_b("thaumic_gadgets")) {
            NBTTagList list = nbt.func_150295_c("thaumic_gadgets", 10);
            NBTTagCompound compound = list.func_150305_b(Reference.getNBTPlayerIndexFromString("lightFlying"));
            Long lastUse = compound.func_74763_f("lastAbilityUse");
            int duration = compound.func_74762_e("duration");
            if (lastUse + (long)duration > player.field_70170_p.func_82737_E()) {
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75100_b = true;
                player.func_71016_p();
            } else if (lastUse + (long)duration == player.field_70170_p.func_82737_E()) {
                player.field_71075_bZ.field_75101_c = false;
                if (!player.field_70122_E) {
                    player.field_71075_bZ.field_75100_b = false;
                }
                player.func_71016_p();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onDrawParticles(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            PlayerFlyHandler.checkShadowArmor(player);
        }
    }

    @SubscribeEvent
    public static void checkBootsForStep(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = player.field_71071_by.func_70440_f(0);
            if (stack.func_77973_b() != Items.field_190931_a) {
                if (stack.func_77973_b() instanceof ArmorPrimal || stack.func_77973_b() instanceof ArmorLight || stack.func_77973_b() instanceof ArmorShade) {
                    player.field_70138_W = 1.25f;
                }
            } else {
                player.field_70138_W = 0.61f;
            }
        }
    }

    private static void checkShadowArmor(EntityPlayer player) {
        int i = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!(stack.func_77973_b() instanceof ArmorShade)) continue;
            ++i;
        }
        IBaublesItemHandler handler2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
        ItemStack belt = handler2.getStackInSlot(3);
        if (belt.func_77973_b() instanceof ShadeBelt) {
            ++i;
        }
        if (i == 5) {
            RandomFunctions cfr_ignored_0 = PlayerFlyHandler.ps.rf;
            int count = RandomFunctions.rand.nextInt(2) + 1;
            RandomFunctions cfr_ignored_1 = PlayerFlyHandler.ps.rf;
            double height = (double)player.func_180425_c().func_177956_o() + RandomFunctions.rand.nextDouble() * (double)player.field_70131_O;
            EnumFacing face = player.func_174811_aO();
            switch (face) {
                case NORTH: {
                    RandomFunctions cfr_ignored_2 = PlayerFlyHandler.ps.rf;
                    RandomFunctions cfr_ignored_3 = PlayerFlyHandler.ps.rf;
                    ps.spawnParticles(EnumParticleTypes.SMOKE_NORMAL, count, (double)((float)player.func_180425_c().func_177958_n() + RandomFunctions.rand.nextFloat() - 0.5f), height, (double)((float)player.func_180425_c().func_177952_p() + RandomFunctions.rand.nextFloat()), 0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    RandomFunctions cfr_ignored_4 = PlayerFlyHandler.ps.rf;
                    RandomFunctions cfr_ignored_5 = PlayerFlyHandler.ps.rf;
                    ps.spawnParticles(EnumParticleTypes.SMOKE_NORMAL, count, (double)((float)player.func_180425_c().func_177958_n() + RandomFunctions.rand.nextFloat() - 0.75f), height, (double)((float)player.func_180425_c().func_177952_p() - RandomFunctions.rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    RandomFunctions cfr_ignored_6 = PlayerFlyHandler.ps.rf;
                    RandomFunctions cfr_ignored_7 = PlayerFlyHandler.ps.rf;
                    ps.spawnParticles(EnumParticleTypes.SMOKE_NORMAL, count, (double)((float)player.func_180425_c().func_177958_n() - RandomFunctions.rand.nextFloat() / 2.0f - 0.25f), height, (double)((float)player.func_180425_c().func_177952_p() - RandomFunctions.rand.nextFloat() + 0.5f), 0.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    RandomFunctions cfr_ignored_8 = PlayerFlyHandler.ps.rf;
                    RandomFunctions cfr_ignored_9 = PlayerFlyHandler.ps.rf;
                    ps.spawnParticles(EnumParticleTypes.SMOKE_NORMAL, count, (double)((float)player.func_180425_c().func_177958_n() - RandomFunctions.rand.nextFloat() / 2.0f + 1.0f), height, (double)((float)player.func_180425_c().func_177952_p() + RandomFunctions.rand.nextFloat() - 0.5f), 0.0, 0.0, 0.0);
                    break;
                }
            }
        }
    }
}

