/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.util;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;

public interface IFunctionLibrary {
    public static int getCrystalModeFromName(String str) {
        if (str.contains("oval_crystal_air")) {
            return 0;
        }
        if (str.contains("oval_crystal_fire")) {
            return 1;
        }
        if (str.contains("oval_crystal_water")) {
            return 2;
        }
        if (str.contains("oval_crystal_earth")) {
            return 3;
        }
        if (str.contains("oval_crystal_order")) {
            return 4;
        }
        if (str.contains("oval_crystal_entropy")) {
            return 5;
        }
        return 6;
    }

    public static Aspect getAspectFromMode(int mode) {
        switch (mode) {
            case 0: {
                return Aspect.AIR;
            }
            case 1: {
                return Aspect.FIRE;
            }
            case 2: {
                return Aspect.WATER;
            }
            case 3: {
                return Aspect.EARTH;
            }
            case 4: {
                return Aspect.ORDER;
            }
            case 5: {
                return Aspect.ENTROPY;
            }
        }
        return null;
    }

    public static Aspect getAspectFromName(String name) {
        if (name.contains("oval_crystal_air")) {
            return Aspect.AIR;
        }
        if (name.contains("oval_crystal_fire")) {
            return Aspect.FIRE;
        }
        if (name.contains("oval_crystal_water")) {
            return Aspect.WATER;
        }
        if (name.contains("oval_crystal_earth")) {
            return Aspect.EARTH;
        }
        if (name.contains("oval_crystal_order")) {
            return Aspect.ORDER;
        }
        if (name.contains("oval_crystal_entropy")) {
            return Aspect.ENTROPY;
        }
        return null;
    }

    public static IBakedModel loadModelObj(ResourceLocation modelLoc) {
        TRSRTransformation state = TRSRTransformation.identity();
        VertexFormat format = DefaultVertexFormats.field_176600_a;
        Function getter = ModelLoader.defaultTextureGetter();
        IBakedModel model = ModelLoaderRegistry.getMissingModel().bake((IModelState)state, format, getter);
        try {
            model = OBJLoader.INSTANCE.loadModel(modelLoc).bake((IModelState)state, format, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static IBakedModel loadModelJson(ResourceLocation modelLoc) {
        TRSRTransformation state = TRSRTransformation.identity();
        VertexFormat format = DefaultVertexFormats.field_176600_a;
        Function getter = ModelLoader.defaultTextureGetter();
        IBakedModel model = ModelLoaderRegistry.getMissingModel().bake((IModelState)state, format, getter);
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)modelLoc).bake((IModelState)state, format, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPointInRegion(int sX, int sY, int fX, int fY, int mouseX, int mouseY) {
        return mouseX > sX && mouseX < sX + fX && mouseY > sY && mouseY < sY + fY;
    }

    public static RayTraceResult rayTrace(Entity ent, double reachDistance) {
        Vec3d start = new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v);
        Vec3d finish = start.func_178787_e(ent.func_70040_Z().func_186678_a(reachDistance));
        return ent.field_70170_p.func_147447_a(start, finish, false, false, true);
    }
}

