/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.terramorfer;

import com.ancient.thaumicgadgets.network.MessageClientTerramorfer;
import com.ancient.thaumicgadgets.proxy.CommonProxy;
import com.ancient.thaumicgadgets.util.handlers.EnumHandler;
import com.ancient.thaumicgadgets.util.handlers.NetworkHandler;
import com.ancient.thaumicgadgets.util.handlers.ParticleSpawner;
import com.ancient.thaumicgadgets.util.handlers.RandomFunctions;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.lib.events.EssentiaHandler;

public class TileEntityTerramorfer
extends TileEntity
implements ITickable {
    public int focusType = 474;
    public int currentChargeTime = 0;
    public int maxChargeTime = 40;
    private final Map<Aspect, Integer> aspectList = Maps.newHashMap();
    private static final ParticleSpawner ps = ParticleSpawner.INSTANCE;

    public TileEntityTerramorfer() {
        this.aspectList.put(Aspect.COLD, 0);
        this.aspectList.put(Aspect.FIRE, 0);
        this.aspectList.put(Aspect.ENERGY, 0);
        this.aspectList.put(Aspect.PLANT, 0);
        this.aspectList.put(Aspect.MAGIC, 0);
        this.aspectList.put(Aspect.EARTH, 0);
        this.aspectList.put(Aspect.WATER, 0);
        this.aspectList.put(Aspect.BEAST, 0);
    }

    public void AddFocus(ItemStack item) {
        if (this.focusType < 10) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), new ItemStack(Item.func_150898_a((Block)CommonProxy.blockFocus), 1, this.focusType)));
        }
        item.func_190918_g(1);
        this.focusType = item.func_77960_j();
        NetworkHandler.sendToAllNearby(new MessageClientTerramorfer(this.focusType, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void RemoveFocus() {
        if (this.focusType < 10) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), new ItemStack(Item.func_150898_a((Block)CommonProxy.blockFocus), 1, this.focusType)));
        }
        this.focusType = 474;
        NetworkHandler.sendToAllNearby(new MessageClientTerramorfer(this.focusType, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("focusType", this.focusType);
        compound.func_74768_a("chargeTime", this.currentChargeTime);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.focusType = compound.func_74762_e("focusType");
        this.currentChargeTime = compound.func_74762_e("chargeTime");
    }

    public boolean canWork(Aspect as) {
        return this.focusType < 10 && AuraHelper.getVis(this.field_145850_b, this.field_174879_c) > 10.0f;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            byte b = 0;
            Aspect as = null;
            int count = 0;
            switch (this.focusType) {
                case 0: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76768_g);
                    as = Aspect.COLD;
                    count = 5;
                    break;
                }
                case 1: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76769_d);
                    as = Aspect.FIRE;
                    count = 5;
                    break;
                }
                case 2: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76778_j);
                    as = Aspect.ENERGY;
                    count = 5;
                    break;
                }
                case 3: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76782_w);
                    as = Aspect.PLANT;
                    count = 5;
                    break;
                }
                case 4: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76789_p);
                    as = Aspect.MAGIC;
                    count = 5;
                    break;
                }
                case 5: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76772_c);
                    as = Aspect.EARTH;
                    count = 5;
                    break;
                }
                case 6: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76774_n);
                    as = Aspect.COLD;
                    count = 10;
                    break;
                }
                case 7: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76767_f);
                    as = Aspect.PLANT;
                    count = 5;
                    break;
                }
                case 8: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_76780_h);
                    as = Aspect.WATER;
                    count = 5;
                    break;
                }
                case 9: {
                    b = (byte)Biome.func_185362_a((Biome)Biomes.field_150588_X);
                    as = Aspect.BEAST;
                    count = 3;
                }
            }
            if (this.canWork(as)) {
                if (this.aspectList.get(as) < count && EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)as, (EnumFacing)EnumFacing.DOWN, (int)2, (int)1)) {
                    this.aspectList.replace(as, this.aspectList.get(as) + 1);
                }
                if (this.currentChargeTime >= this.maxChargeTime && this.aspectList.get(as) >= count) {
                    this.currentChargeTime = 0;
                    this.aspectList.replace(as, 0);
                    RandomFunctions cfr_ignored_0 = TileEntityTerramorfer.ps.rf;
                    int newx = this.field_174879_c.func_177958_n() + RandomFunctions.rand.nextInt(33) - 16;
                    RandomFunctions cfr_ignored_1 = TileEntityTerramorfer.ps.rf;
                    int newz = this.field_174879_c.func_177952_p() + RandomFunctions.rand.nextInt(33) - 16;
                    BlockPos newpos = new BlockPos(newx, this.field_174879_c.func_177956_o(), newz);
                    int relX = newx & 0xF;
                    int relZ = newz & 0xF;
                    Chunk chunk = this.field_145850_b.func_175726_f(newpos);
                    byte[] q = chunk.func_76605_m();
                    q[relZ << 4 | relX] = b;
                    chunk.func_76616_a(q);
                    chunk.func_76630_e();
                    AuraHelper.drainVis(this.field_145850_b, this.field_174879_c, 5.0f, false);
                    RandomFunctions cfr_ignored_2 = TileEntityTerramorfer.ps.rf;
                    ps.transferData(EnumParticleTypes.DRAGON_BREATH, RandomFunctions.rand.nextInt(3) + 3, (double)newx, (double)this.field_174879_c.func_177956_o(), (double)newz, TileEntityTerramorfer.ps.rf.getRandomPartcileVelocity(0.1), 0.1, TileEntityTerramorfer.ps.rf.getRandomPartcileVelocity(0.1), this.field_145850_b.field_73011_w.getDimension());
                }
                ++this.currentChargeTime;
            } else {
                this.currentChargeTime = 0;
            }
        }
    }

    public boolean isBiomeEquvivalent(Biome biome, int focus) {
        return biome.func_185359_l().toLowerCase() == EnumHandler.FocusTypes.values()[focus].func_176610_l().toLowerCase();
    }
}

