/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.teleportator;

import com.ancient.thaumicgadgets.Main;
import com.ancient.thaumicgadgets.network.MessageClientTeleportatorVisCount;
import com.ancient.thaumicgadgets.objects.machines.teleportator.TeleportatorManager;
import com.ancient.thaumicgadgets.util.ICheckMultiBlock;
import com.ancient.thaumicgadgets.util.IWorldPos;
import com.ancient.thaumicgadgets.util.handlers.EnumHandler;
import com.ancient.thaumicgadgets.util.handlers.NetworkHandler;
import com.ancient.thaumicgadgets.util.handlers.RandomFunctions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import thaumcraft.api.aura.AuraHelper;

public class TileEntityTeleportator
extends TileEntity
implements ITickable {
    public static final int NEED_VIS = 500;
    private static final int SUCK_PER_TICK = 25;
    private float visCount = 0.0f;
    private List<Entity> ent = new ArrayList<Entity>();
    private List<IWorldPos.worldPos> teleportList = new ArrayList<IWorldPos.worldPos>();
    private String customName = "";
    private UUID owner = new UUID(0L, 0L);
    private List<String> whiteList = new ArrayList<String>();
    private List<String> blackList = new ArrayList<String>();
    private int useList = 0;
    private boolean wasGenerated = false;
    private IWorldPos.worldPos dungeonCoord = IWorldPos.worldPos.EMPTY;
    private RandomFunctions rf = RandomFunctions.INSTANCE;

    public TileEntityTeleportator() {
    }

    public TileEntityTeleportator(boolean wasGenereted, int dimen, int posX, int posY, int posZ) {
        this.wasGenerated = true;
        this.dungeonCoord = new IWorldPos.worldPos(dimen, posX, posY, posZ);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 4L == 0L && !ICheckMultiBlock.checkMultiBlockStatic(this.field_145850_b, Main.MMB.getMultiBlockRecipeList().get((Object)EnumHandler.MultiBlocks.TELEPORTATOR.getName()).recipe, new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p()))) {
                AuraHelper.polluteAura(this.field_145850_b, this.field_174879_c, this.visCount / 100.0f, true);
                AuraHelper.addVis(this.field_145850_b, this.field_174879_c, this.visCount / 5.0f);
                ICheckMultiBlock.demorphMultiBlockStatic(this.field_145850_b, Main.MMB.getMultiBlockRecipeList().get((Object)EnumHandler.MultiBlocks.TELEPORTATOR.getName()).recipe, new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p()));
                return;
            }
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                if (this.visCount < 500.0f) {
                    this.visCount += AuraHelper.drainVis(this.field_145850_b, this.field_174879_c, 25.0f, false);
                }
                NetworkHandler.sendToAllNearby(new MessageClientTeleportatorVisCount(this.visCount, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 50.0));
            }
        }
    }

    public void startTelepotation(IWorldPos.worldPos finishPoint) {
        if (!this.field_145850_b.field_72995_K && !finishPoint.equals(IWorldPos.worldPos.EMPTY)) {
            if (this.visCount >= 500.0f) {
                this.visCount -= 500.0f;
                AxisAlignedBB scanEntity = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() + 2));
                List entities = this.field_145850_b.func_72872_a(Entity.class, scanEntity);
                ArrayList pls = Lists.newArrayList();
                if (!entities.isEmpty()) {
                    for (Entity ent : entities) {
                        if (ent instanceof EntityPlayerMP) {
                            EntityPlayerMP pl = (EntityPlayerMP)ent;
                            pls.add(pl);
                            continue;
                        }
                        if (this.field_145850_b.field_73011_w.getDimension() == finishPoint.dimension) {
                            ent.func_70634_a((double)finishPoint.x + this.rf.getRandomPartcileVelocity(1.0), (double)(finishPoint.y - 2), (double)finishPoint.z + this.rf.getRandomPartcileVelocity(1.0));
                            continue;
                        }
                        WorldServer oldWorld = ent.func_184102_h().func_71218_a(ent.field_71093_bK);
                        ent.field_71093_bK = finishPoint.dimension;
                        WorldServer newWorld = ent.func_184102_h().func_71218_a(ent.field_71093_bK);
                        TeleportatorManager.transferEntityToWorldCustomCoords(ent, oldWorld, newWorld, new IWorldPos.worldPos(finishPoint.dimension, (double)finishPoint.x + this.rf.getRandomPartcileVelocity(1.0), (double)(finishPoint.y - 2), (double)finishPoint.z + this.rf.getRandomPartcileVelocity(1.0)));
                    }
                }
                if (!pls.isEmpty()) {
                    for (EntityPlayerMP pl : pls) {
                        if (pl.field_71093_bK == finishPoint.dimension) {
                            pl.func_70634_a((double)finishPoint.x + this.rf.getRandomPartcileVelocity(1.0), (double)(finishPoint.y - 2), (double)finishPoint.z + this.rf.getRandomPartcileVelocity(1.0));
                            continue;
                        }
                        PlayerList list = pl.func_184102_h().func_184103_al();
                        TeleportatorManager.transferPlayerToDimensionCustomCoords(pl, new IWorldPos.worldPos(finishPoint.dimension, (double)finishPoint.x + this.rf.getRandomPartcileVelocity(1.0), (double)(finishPoint.y - 2), (double)finishPoint.z + this.rf.getRandomPartcileVelocity(1.0)), list);
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.customName = compound.func_74779_i("customName");
        this.visCount = compound.func_74760_g("visCount");
        this.owner = compound.func_186857_a("owner");
        this.useList = compound.func_74762_e("useList");
        this.blackList.clear();
        NBTTagList black = compound.func_150295_c("blackList", 10);
        if (black.func_74745_c() > 0) {
            for (int q = 0; q < black.func_74745_c(); ++q) {
                this.blackList.add(black.func_150305_b(q).func_74779_i("blackList"));
            }
        }
        NBTTagList white = compound.func_150295_c("whiteList", 10);
        if (black.func_74745_c() > 0) {
            for (int q = 0; q < black.func_74745_c(); ++q) {
                this.blackList.add(black.func_150305_b(q).func_74779_i("whiteList"));
            }
        }
        this.wasGenerated = compound.func_74767_n("wasGenerated");
        if (this.wasGenerated) {
            this.dungeonCoord = new IWorldPos.worldPos(compound.func_74762_e("dimen"), compound.func_74762_e("posX"), compound.func_74762_e("posY"), compound.func_74762_e("posZ"));
        }
    }

    public boolean hasCustomName() {
        return !this.customName.equals("");
    }

    public void setCustomName(String str) {
        this.customName = str;
    }

    public String getCustomName() {
        return this.customName;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound com;
        super.func_189515_b(compound);
        compound.func_74778_a("customName", this.customName);
        compound.func_74776_a("visCount", this.visCount);
        compound.func_186854_a("owner", this.owner);
        compound.func_74768_a("useList", this.useList);
        if (!this.blackList.isEmpty()) {
            NBTTagList black = new NBTTagList();
            for (String s : this.blackList) {
                com = new NBTTagCompound();
                com.func_74778_a("blackList", s);
                black.func_74742_a((NBTBase)com);
            }
            compound.func_74782_a("blackList", (NBTBase)black);
        }
        if (!this.whiteList.isEmpty()) {
            NBTTagList white = new NBTTagList();
            for (String s : this.blackList) {
                com = new NBTTagCompound();
                com.func_74778_a("whiteList", s);
                white.func_74742_a((NBTBase)com);
            }
            compound.func_74782_a("whiteList", (NBTBase)white);
        }
        compound.func_74757_a("wasGenerated", this.wasGenerated);
        if (this.wasGenerated) {
            compound.func_74768_a("dimen", this.dungeonCoord.dimension);
            compound.func_74768_a("posX", this.dungeonCoord.x);
            compound.func_74768_a("posY", this.dungeonCoord.y);
            compound.func_74768_a("posZ", this.dungeonCoord.z);
        }
        return compound;
    }

    public float getVisCount() {
        return this.visCount;
    }

    public void setVisCount(float visCount) {
        this.visCount = visCount;
    }
}

