/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.gemcutter;

import com.ancient.thaumicgadgets.network.gemcutter.MessageClientAllAspects;
import com.ancient.thaumicgadgets.objects.machines.gemcutter.GemCutterRecipes;
import com.ancient.thaumicgadgets.util.handlers.NetworkHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class TileEntityGemCutter
extends TileEntity
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private AspectList aspectList = new AspectList();
    private AspectList choosedAspects = new AspectList();
    private String customName;
    public final int maxWorkTime = 40;
    private int workTime;
    private int mode = 0;

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.gemcutter";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && index + 1 == 1 && !flag) {
            ItemStack stack1 = (ItemStack)this.inventory.get(index + 1);
            this.mode = 0;
            this.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("mode", (int)((short)this.mode));
        compound.func_74768_a("workTime", this.workTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("customName", this.customName);
        }
        this.aspectList.writeToNBT(compound, "aspects");
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.mode = compound.func_74762_e("ode");
        this.workTime = compound.func_74762_e("workTime");
        if (compound.func_150297_b("customName", 8)) {
            this.setCustomName(compound.func_74779_i("customName"));
        }
        this.aspectList.readFromNBT(compound, "aspects");
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public static int currentMode(IInventory inventory) {
        return inventory.func_174887_a_(0);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getWorkTime(IInventory inventory) {
        return inventory.func_174887_a_(1);
    }

    public boolean canWork() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack result = GemCutterRecipes.getInstance().getWorkResult((ItemStack)this.inventory.get(0), this.choosedAspects, this.mode);
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(2);
        if (output.func_190926_b()) {
            return true;
        }
        if (!ItemStack.func_77989_b((ItemStack)output, (ItemStack)result)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        return res < this.func_70297_j_() && res <= output.func_77976_d();
    }

    public void craftItem() {
        if (this.canWork()) {
            ItemStack input0 = (ItemStack)this.inventory.get(0);
            GemCutterRecipes.gemCutterRecipe rec = GemCutterRecipes.getInstance().getRecipeEntry(input0, this.choosedAspects, this.mode);
            if (rec != null) {
                ItemStack result = rec.outPut;
                ItemStack output = (ItemStack)this.inventory.get(2);
                if (output.func_190926_b()) {
                    for (Aspect as : rec.aspects.getAspects()) {
                        this.aspectList.reduce(as, rec.aspects.getAmount(as));
                    }
                    input0.func_190918_g(rec.input.func_190916_E());
                    this.inventory.set(2, (Object)result.func_77946_l());
                }
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 2;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.mode;
            }
            case 1: {
                return this.workTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.mode = value;
                break;
            }
            case 1: {
                this.workTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public String getGuiID() {
        return "tg:gemcutter";
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack item1 = (ItemStack)this.inventory.get(0);
            ItemStack item2 = (ItemStack)this.inventory.get(1);
            while (!GemCutterRecipes.containOnlyPrimalAspects(this.aspectList)) {
                this.aspectList = GemCutterRecipes.toPrimal(this.aspectList);
            }
            if (item2 != ItemStack.field_190927_a) {
                if (AspectHelper.getObjectAspects(item2).size() > 0) {
                    AspectList asL;
                    if (++this.workTime == 40 && (asL = AspectHelper.getObjectAspects(item2)) != null && asL.size() > 0) {
                        for (Aspect as : asL.getAspects()) {
                            asL.add(as, asL.getAmount(as));
                        }
                        this.aspectList.add(asL);
                        while (!GemCutterRecipes.containOnlyPrimalAspects(this.aspectList)) {
                            this.aspectList = GemCutterRecipes.toPrimal(this.aspectList);
                        }
                        ItemStack st = (ItemStack)this.inventory.get(1);
                        if (st.func_190916_E() > 1) {
                            st.func_190918_g(1);
                        } else {
                            st = ItemStack.field_190927_a;
                        }
                        this.inventory.set(1, (Object)st);
                        this.workTime = 0;
                    }
                } else {
                    this.workTime = 0;
                }
            } else {
                this.workTime = 0;
            }
            flag1 = true;
        }
        if (flag1) {
            NetworkHandler.sendToAllNearby(new MessageClientAllAspects(this.aspectList, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            this.func_70296_d();
        }
    }

    public void setChoosedAspects(AspectList choosedAspects) {
        this.choosedAspects = choosedAspects;
    }

    public AspectList getAspectList() {
        return this.aspectList;
    }

    public void setAspectList(AspectList aspectList) {
        this.aspectList = aspectList;
    }
}

