/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.extruder;

import com.ancient.thaumicgadgets.util.handlers.EnumHandler;
import com.ancient.thaumicgadgets.util.handlers.ParticleSpawner;
import com.ancient.thaumicgadgets.util.handlers.RandomFunctions;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityExtruder
extends TileEntity
implements ITickable {
    private int workTime = 0;
    private int maxWorkTime = this.getWorkTime();
    private static final ParticleSpawner ps = ParticleSpawner.INSTANCE;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("WorkTime", (int)((short)this.workTime));
        compound.func_74768_a("MaxWorkTime", (int)((short)this.maxWorkTime));
        return compound;
    }

    public boolean canWork() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.workTime = compound.func_74762_e("WorkTime");
        this.maxWorkTime = compound.func_74762_e("MaxWorkTime");
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isWorking(TileEntityExtruder ent) {
        return ent.getField(0) > 0;
    }

    public boolean isWorking() {
        return this.workTime > 0;
    }

    public int getWorkTime() {
        return 100;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.workTime;
            }
            case 1: {
                return this.maxWorkTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.workTime = value;
                break;
            }
            case 1: {
                this.maxWorkTime = value;
            }
        }
    }

    public int getFieldCount() {
        return 2;
    }

    public void func_73660_a() {
        boolean flag = this.isWorking();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            int dim = this.field_145850_b.field_73011_w.getDimension();
            if (this.canWork()) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                ++this.workTime;
                if (this.workTime % 7 == 0) {
                    ps.transferData(EnumHandler.CustomParticles.SMOKE, 1, (double)(this.field_174879_c.func_177958_n() + face.func_82601_c()), (double)this.field_174879_c.func_177956_o() + 0.1, (double)(this.field_174879_c.func_177952_p() + face.func_82599_e()), TileEntityExtruder.ps.rf.getRandomPartcileVelocity(0.02), 0.05, TileEntityExtruder.ps.rf.getRandomPartcileVelocity(0.02), dim);
                }
                if (this.workTime >= this.maxWorkTime) {
                    this.workTime = 0;
                    this.maxWorkTime = this.getWorkTime();
                    EntityItem cobble = null;
                    switch (face) {
                        case NORTH: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 0.5, new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1));
                            break;
                        }
                        case SOUTH: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.5, new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1));
                            break;
                        }
                        case EAST: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1));
                            break;
                        }
                        case WEST: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1));
                            break;
                        }
                    }
                    cobble.field_70159_w = 0.025;
                    cobble.field_70181_x = 0.075;
                    cobble.field_70179_y = 0.025;
                    RandomFunctions cfr_ignored_0 = TileEntityExtruder.ps.rf;
                    ps.transferData(EnumParticleTypes.LAVA, RandomFunctions.rand.nextInt(5) + 1, cobble.field_70165_t, cobble.field_70163_u, cobble.field_70161_v, dim);
                    RandomFunctions cfr_ignored_1 = TileEntityExtruder.ps.rf;
                    ps.transferData(EnumParticleTypes.SMOKE_NORMAL, RandomFunctions.rand.nextInt(5) + 1, cobble.field_70165_t, cobble.field_70163_u, cobble.field_70161_v, dim);
                    this.field_145850_b.func_72838_d((Entity)cobble);
                    flag1 = true;
                }
            } else {
                this.workTime = 0;
            }
            if (flag == this.isWorking()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }
}

