/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.dechantmenttable;

import com.ancient.thaumicgadgets.Main;
import com.ancient.thaumicgadgets.entity.entity.EntityObserver;
import com.ancient.thaumicgadgets.init.ModBlocks;
import com.ancient.thaumicgadgets.network.MessageClientDechantment;
import com.ancient.thaumicgadgets.objects.machines.book_holder.TileEntityBookHolder;
import com.ancient.thaumicgadgets.util.ICheckMultiBlock;
import com.ancient.thaumicgadgets.util.handlers.EnumHandler;
import com.ancient.thaumicgadgets.util.handlers.NetworkHandler;
import com.ancient.thaumicgadgets.util.handlers.ParticleSpawner;
import com.ancient.thaumicgadgets.util.handlers.RandomFunctions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDechantmentTable
extends TileEntity
implements ITickable,
ICheckMultiBlock {
    private int maxParticleTime;
    private int particleTime;
    private int maxWorkTime;
    private int workTime = 0;
    private ItemStack item;
    private List<BlockPos> neighbor = Lists.newArrayList();
    private List<BlockPos> statues = Lists.newArrayList();
    private List<EntityObserver> sec = Lists.newArrayList();
    private static final ParticleSpawner ps = ParticleSpawner.INSTANCE;

    public TileEntityDechantmentTable() {
        this.maxWorkTime = this.getMaxWorkTime();
        this.item = ItemStack.field_190927_a;
        RandomFunctions cfr_ignored_0 = TileEntityDechantmentTable.ps.rf;
        this.maxParticleTime = RandomFunctions.rand.nextInt(11);
        this.particleTime = 0;
    }

    public void AddItem(ItemStack item) {
        this.item = item.func_77946_l();
        item.func_190918_g(1);
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void RemoveItem() {
        EntityItem ent = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, this.item);
        ent.field_70159_w = 0.0;
        ent.field_70181_x = 0.1;
        ent.field_70179_y = 0.0;
        this.field_145850_b.func_72838_d((Entity)ent);
        this.item = ItemStack.field_190927_a;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("WorkTime", (int)((short)this.workTime));
        compound.func_74768_a("MaxWorkTime", (int)((short)this.maxWorkTime));
        NBTTagCompound compoundItem = new NBTTagCompound();
        compoundItem = this.item.serializeNBT();
        compound.func_74782_a("Item", (NBTBase)compoundItem);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.workTime = compound.func_74762_e("WorkTime");
        this.maxWorkTime = compound.func_74762_e("MaxWorkTime");
        this.item = new ItemStack(compound.func_74775_l("Item"));
    }

    public boolean canWork() {
        return true;
    }

    public boolean isWorking() {
        return this.workTime > 0;
    }

    public int getWorkingTime() {
        return this.workTime;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            NetworkHandler.sendToAllNearby(new MessageClientDechantment(this.item, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 50.0));
            if (!this.item.equals(ItemStack.field_190927_a)) {
                TileEntityBookHolder holder;
                if (ICheckMultiBlock.checkMultiBlockStatic(this.field_145850_b, Main.MMB.getMultiBlockRecipeList().get((Object)EnumHandler.MultiBlocks.DECHANT2.getName()).recipe, this.field_174879_c.func_177984_a())) {
                    holder = (TileEntityBookHolder)this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2));
                    if (!holder.isEmpty()) {
                        this.workAsTransferChant2(holder);
                    }
                } else if (ICheckMultiBlock.checkMultiBlockStatic(this.field_145850_b, Main.MMB.getMultiBlockRecipeList().get((Object)EnumHandler.MultiBlocks.DECHANT1.getName()).recipe, this.field_174879_c.func_177984_a())) {
                    holder = (TileEntityBookHolder)this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2));
                    if (!holder.isEmpty()) {
                        this.workAsTransferChant1(holder);
                    }
                } else {
                    this.workAsDechant();
                }
            }
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.neighbor = this.getNeighbor();
                this.statues = this.getStatues();
                AxisAlignedBB aabb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 5), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 5), (double)(this.field_174879_c.func_177958_n() + 6), (double)(this.field_174879_c.func_177956_o() + 7), (double)(this.field_174879_c.func_177952_p() + 6));
                List players = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
                boolean b = false;
                for (BlockPos glass : this.neighbor) {
                    if (this.field_145850_b.func_180495_p(glass).func_177230_c() == ModBlocks.FORTIFIED_GLASS || !this.checkStatue(this.statues) && this.checkMobs()) continue;
                    this.field_145850_b.func_175656_a(glass, ModBlocks.FORTIFIED_GLASS.func_176223_P());
                    b = true;
                }
                if (b) {
                    this.sec.clear();
                    for (BlockPos statue : this.statues) {
                        if (this.field_145850_b.func_180495_p(statue).func_177230_c() != ModBlocks.STATUE) continue;
                        this.field_145850_b.func_175656_a(statue, Blocks.field_150350_a.func_176223_P());
                        this.field_145850_b.func_175656_a(statue.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                        EntityObserver mob = new EntityObserver(this.field_145850_b);
                        mob.func_70012_b((double)statue.func_177958_n() + 0.5, statue.func_177956_o(), (double)statue.func_177952_p() + 0.5, 0.0f, 0.0f);
                        if (players.size() > 0) {
                            RandomFunctions cfr_ignored_0 = TileEntityDechantmentTable.ps.rf;
                            mob.func_70624_b((EntityLivingBase)players.get(RandomFunctions.rand.nextInt(players.size())));
                        }
                        this.field_145850_b.func_72838_d((Entity)mob);
                        this.sec.add(mob);
                    }
                }
                if (players.isEmpty() && !this.checkMobs()) {
                    int i = 0;
                    for (EntityObserver mob : this.sec) {
                        if (!(mob.func_110143_aJ() > 0.0f)) continue;
                        mob.func_70106_y();
                        this.field_145850_b.func_175656_a(this.statues.get(i), ModBlocks.STATUE.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)i)));
                        this.field_145850_b.func_175656_a(this.statues.get(i).func_177984_a(), ModBlocks.DUMMY.func_176223_P());
                        ++i;
                    }
                }
            }
        }
    }

    private void workAsTransferChant2(TileEntityBookHolder holder) {
        int dim = holder.func_145831_w().field_73011_w.getDimension();
        int enchCount = this.item.func_77986_q().func_74745_c();
        if (enchCount > 0 && !holder.getItem().func_190926_b()) {
            this.maxWorkTime = 0;
            for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)this.item).entrySet()) {
                this.maxWorkTime += this.getMaxWorkTime() * (Integer)e.getValue();
            }
            ++this.workTime;
            if (this.workTime % 3 == 0) {
                RandomFunctions cfr_ignored_0 = TileEntityDechantmentTable.ps.rf;
                RandomFunctions cfr_ignored_1 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumHandler.CustomParticles.BUBBLE, 1, (double)this.field_174879_c.func_177958_n() + RandomFunctions.rand.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + RandomFunctions.rand.nextDouble(), TileEntityDechantmentTable.ps.rf.getRandomPartcileVelocity(0.02), 0.05, TileEntityDechantmentTable.ps.rf.getRandomPartcileVelocity(0.02), dim);
            }
            List<BlockPos> list = this.findEyes(1);
            RandomFunctions cfr_ignored_2 = TileEntityDechantmentTable.ps.rf;
            BlockPos spawnPos = list.get(RandomFunctions.rand.nextInt(list.size()));
            Vec3d vec = new Vec3d((double)(spawnPos.func_177958_n() - this.field_174879_c.func_177958_n()), (double)(spawnPos.func_177956_o() - this.field_174879_c.func_177956_o()), (double)(spawnPos.func_177952_p() - this.field_174879_c.func_177952_p())).func_72432_b();
            if (this.particleTime++ >= this.maxParticleTime) {
                this.particleTime = 0;
                RandomFunctions cfr_ignored_3 = TileEntityDechantmentTable.ps.rf;
                this.maxParticleTime = RandomFunctions.rand.nextInt(11);
                RandomFunctions cfr_ignored_4 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.ENCHANTMENT_TABLE, 1, (double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p(), vec.field_72450_a * 3.0, (double)RandomFunctions.rand.nextFloat() - 0.5, vec.field_72449_c * 3.0, dim);
            }
            if (this.workTime >= this.maxWorkTime) {
                ItemStack enchBook = new ItemStack(Items.field_151134_bR);
                for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)this.item).entrySet()) {
                    if (e.getKey() == Enchantments.field_190941_k || e.getKey() == Enchantments.field_190940_C) continue;
                    EnchantmentData enchData = new EnchantmentData((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue());
                    ItemEnchantedBook.func_92115_a((ItemStack)enchBook, (EnchantmentData)enchData);
                }
                holder.setItem(enchBook);
                this.workTime = 0;
                RandomFunctions cfr_ignored_5 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.LAVA, RandomFunctions.rand.nextInt(5) + 1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, dim);
                RandomFunctions cfr_ignored_6 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.SMOKE_NORMAL, RandomFunctions.rand.nextInt(5) + 1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, dim);
                this.item.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            this.func_70296_d();
        }
    }

    private void workAsTransferChant1(TileEntityBookHolder holder) {
        int dim = holder.func_145831_w().field_73011_w.getDimension();
        int enchCount = this.item.func_77986_q().func_74745_c();
        if (enchCount > 0 && !holder.getItem().func_190926_b()) {
            this.maxWorkTime = 0;
            for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)this.item).entrySet()) {
                this.maxWorkTime += this.getMaxWorkTime() * (Integer)e.getValue();
            }
            ++this.workTime;
            if (this.workTime % 3 == 0) {
                RandomFunctions cfr_ignored_0 = TileEntityDechantmentTable.ps.rf;
                RandomFunctions cfr_ignored_1 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumHandler.CustomParticles.BUBBLE, 1, (double)this.field_174879_c.func_177958_n() + RandomFunctions.rand.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + RandomFunctions.rand.nextDouble(), TileEntityDechantmentTable.ps.rf.getRandomPartcileVelocity(0.02), 0.05, TileEntityDechantmentTable.ps.rf.getRandomPartcileVelocity(0.02), dim);
            }
            List<BlockPos> list = this.findEyes(1);
            RandomFunctions cfr_ignored_2 = TileEntityDechantmentTable.ps.rf;
            BlockPos spawnPos = list.get(RandomFunctions.rand.nextInt(list.size()));
            Vec3d vec = new Vec3d((double)(spawnPos.func_177958_n() - this.field_174879_c.func_177958_n()), (double)(spawnPos.func_177956_o() - this.field_174879_c.func_177956_o()), (double)(spawnPos.func_177952_p() - this.field_174879_c.func_177952_p())).func_72432_b();
            if (++this.particleTime >= this.maxParticleTime) {
                this.particleTime = 0;
                RandomFunctions cfr_ignored_3 = TileEntityDechantmentTable.ps.rf;
                this.maxParticleTime = RandomFunctions.rand.nextInt(11);
                RandomFunctions cfr_ignored_4 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.ENCHANTMENT_TABLE, 1, (double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p(), vec.field_72450_a * 3.0, (double)RandomFunctions.rand.nextFloat() - 0.5, vec.field_72449_c * 3.0, dim);
            }
            if (this.workTime >= this.maxWorkTime) {
                EnchantmentData enchData;
                ItemStack enchBook = new ItemStack(Items.field_151134_bR);
                RandomFunctions cfr_ignored_5 = TileEntityDechantmentTable.ps.rf;
                if (RandomFunctions.rand.nextInt(101) > 20) {
                    for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)this.item).entrySet()) {
                        EnchantmentData enchData2 = new EnchantmentData((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue());
                        ItemEnchantedBook.func_92115_a((ItemStack)enchBook, (EnchantmentData)enchData2);
                    }
                }
                RandomFunctions cfr_ignored_6 = TileEntityDechantmentTable.ps.rf;
                if (RandomFunctions.rand.nextInt(101) < 20) {
                    enchData = new EnchantmentData(Enchantments.field_190941_k, 1);
                    ItemEnchantedBook.func_92115_a((ItemStack)enchBook, (EnchantmentData)enchData);
                }
                RandomFunctions cfr_ignored_7 = TileEntityDechantmentTable.ps.rf;
                if (RandomFunctions.rand.nextInt(101) < 20) {
                    enchData = new EnchantmentData(Enchantments.field_190940_C, 1);
                    ItemEnchantedBook.func_92115_a((ItemStack)enchBook, (EnchantmentData)enchData);
                }
                holder.setItem(enchBook);
                this.workTime = 0;
                RandomFunctions cfr_ignored_8 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.LAVA, RandomFunctions.rand.nextInt(5) + 1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, dim);
                RandomFunctions cfr_ignored_9 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.SMOKE_NORMAL, RandomFunctions.rand.nextInt(5) + 1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, dim);
                this.item.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            this.func_70296_d();
        }
    }

    private void workAsDechant() {
        int dim = this.field_145850_b.field_73011_w.getDimension();
        int enchCount = this.item.func_77986_q().func_74745_c();
        if (enchCount > 0) {
            this.maxWorkTime = 0;
            for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)this.item).entrySet()) {
                this.maxWorkTime += this.getMaxWorkTime() * (Integer)e.getValue();
            }
            ++this.workTime;
            if (this.workTime % 3 == 0) {
                RandomFunctions cfr_ignored_0 = TileEntityDechantmentTable.ps.rf;
                RandomFunctions cfr_ignored_1 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumHandler.CustomParticles.BUBBLE, 1, (double)this.field_174879_c.func_177958_n() + RandomFunctions.rand.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + RandomFunctions.rand.nextDouble(), TileEntityDechantmentTable.ps.rf.getRandomPartcileVelocity(0.02), 0.05, TileEntityDechantmentTable.ps.rf.getRandomPartcileVelocity(0.02), dim);
            }
            if (this.workTime >= this.maxWorkTime) {
                this.workTime = 0;
                RandomFunctions cfr_ignored_2 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.LAVA, RandomFunctions.rand.nextInt(5) + 1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, dim);
                RandomFunctions cfr_ignored_3 = TileEntityDechantmentTable.ps.rf;
                ps.transferData(EnumParticleTypes.SMOKE_NORMAL, RandomFunctions.rand.nextInt(5) + 1, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, dim);
                this.item.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            this.func_70296_d();
        }
    }

    private boolean checkStatue(List<BlockPos> statues) {
        boolean b = false;
        for (BlockPos p : statues) {
            if (this.field_145850_b.func_180495_p(p).func_177230_c() != ModBlocks.STATUE) continue;
            b = true;
        }
        return b;
    }

    private List<BlockPos> findEyes(int distance) {
        ArrayList list = Lists.newArrayList();
        list.add(this.field_174879_c.func_177964_d(distance).func_177984_a());
        list.add(this.field_174879_c.func_177970_e(distance).func_177984_a());
        list.add(this.field_174879_c.func_177965_g(distance).func_177984_a());
        list.add(this.field_174879_c.func_177985_f(distance).func_177984_a());
        return list;
    }

    private List<BlockPos> getNeighbor() {
        ArrayList list = Lists.newArrayList();
        list.add(this.field_174879_c.func_177984_a());
        list.add(this.field_174879_c.func_177977_b());
        list.add(this.field_174879_c.func_177978_c());
        list.add(this.field_174879_c.func_177968_d());
        list.add(this.field_174879_c.func_177974_f());
        list.add(this.field_174879_c.func_177976_e());
        return list;
    }

    private List<BlockPos> getStatues() {
        ArrayList list = Lists.newArrayList();
        list.add(this.field_174879_c.func_177964_d(4).func_177984_a());
        list.add(this.field_174879_c.func_177965_g(4).func_177984_a());
        list.add(this.field_174879_c.func_177970_e(4).func_177984_a());
        list.add(this.field_174879_c.func_177985_f(4).func_177984_a());
        return list;
    }

    private boolean checkMobs() {
        return this.sec.isEmpty();
    }

    public boolean isEmpty() {
        return this.item.func_77973_b().equals(Items.field_190931_a);
    }

    public ItemStack getItem() {
        return this.item;
    }

    @SideOnly(value=Side.CLIENT)
    public void setItem(int id) {
        this.item = new ItemStack(Item.func_150899_d((int)id));
    }

    @SideOnly(value=Side.CLIENT)
    public void setWorktime(int newTime) {
        this.workTime = newTime;
    }

    public int getMaxWorkTime() {
        return 300;
    }
}

