/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.network;

import com.ancient.thaumicgadgets.objects.machines.teleportator.GuiTeleportator;
import com.ancient.thaumicgadgets.objects.machines.teleportator.TileEntityTeleportator;
import com.ancient.thaumicgadgets.util.IWorldPos;
import com.ancient.thaumicgadgets.util.Reference;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageClientTeleporterCoords
implements IMessage {
    Map<IWorldPos.worldPos, String> pos = Maps.newHashMap();
    IWorldPos.worldPos tePos;
    String teName;

    public MessageClientTeleporterCoords() {
    }

    public MessageClientTeleporterCoords(NBTTagList coordsList, TileEntityTeleportator te) {
        this.tePos = new IWorldPos.worldPos(te.func_145831_w().field_73011_w.getDimension(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
        this.teName = te.getCustomName();
        for (int q = 0; q < coordsList.func_74745_c(); ++q) {
            NBTTagCompound tag = coordsList.func_150305_b(q);
            IWorldPos.worldPos p = new IWorldPos.worldPos(tag.func_74762_e("dimension"), tag.func_74762_e("posX"), tag.func_74762_e("posY"), tag.func_74762_e("posZ"));
            String name = tag.func_74779_i("name");
            this.pos.put(p, name);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.tePos = new IWorldPos.worldPos(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        this.teName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int size = buf.readInt();
        this.pos.clear();
        for (int q = 0; q < size; ++q) {
            IWorldPos.worldPos p = new IWorldPos.worldPos(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.pos.put(p, name);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tePos.dimension);
        buf.writeInt(this.tePos.x);
        buf.writeInt(this.tePos.y);
        buf.writeInt(this.tePos.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.teName);
        buf.writeInt(this.pos.size());
        for (Map.Entry<IWorldPos.worldPos, String> p : this.pos.entrySet()) {
            buf.writeInt(p.getKey().dimension);
            buf.writeInt(p.getKey().x);
            buf.writeInt(p.getKey().y);
            buf.writeInt(p.getKey().z);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)p.getValue());
        }
    }

    public static class handler
    implements IMessageHandler<MessageClientTeleporterCoords, IMessage> {
        public IMessage onMessage(final MessageClientTeleporterCoords message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    EntityPlayerSP pl = mc.field_71439_g;
                    NBTTagCompound tag = pl.getEntityData();
                    NBTTagList list = tag.func_150295_c("thaumic_gadgets", 10);
                    NBTTagCompound tp = list.func_150305_b(Reference.getNBTPlayerIndexFromString("tpCoords"));
                    NBTTagList coordList = new NBTTagList();
                    for (Map.Entry<IWorldPos.worldPos, String> p : message.pos.entrySet()) {
                        NBTTagCompound t = new NBTTagCompound();
                        t.func_74768_a("dimension", p.getKey().dimension);
                        t.func_74768_a("posX", p.getKey().x);
                        t.func_74768_a("posY", p.getKey().y);
                        t.func_74768_a("posZ", p.getKey().z);
                        t.func_74778_a("name", p.getValue());
                        coordList.func_74742_a((NBTBase)t);
                    }
                    tp.func_74782_a("tpCoords", (NBTBase)coordList);
                    list.func_150304_a(Reference.getNBTPlayerIndexFromString("tpCoords"), (NBTBase)tp);
                    tag.func_74782_a("thaumic_gadgets", (NBTBase)list);
                    TileEntity te = mc.field_71441_e.func_175625_s(new BlockPos(message.tePos.x, message.tePos.y, message.tePos.z));
                    if (te instanceof TileEntityTeleportator) {
                        mc.func_147108_a((GuiScreen)new GuiTeleportator((TileEntityTeleportator)te));
                    }
                }
            });
            return null;
        }
    }
}

