/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.items.pouches;

import com.ancient.thaumicgadgets.Main;
import com.ancient.thaumicgadgets.items.ItemBase;
import com.ancient.thaumicgadgets.util.handlers.EnumHandler;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemPouch
extends ItemBase {
    private UUID defaultUUID = new UUID(0L, 1L);

    public ItemPouch(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entity, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a("playerID", this.defaultUUID);
            stack.func_77982_d(nbt);
        }
        if (stack.func_77977_a().contains("magic") && stack.func_77977_a().contains("pouch")) {
            AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - 2.5, entity.field_70163_u - 2.5, entity.field_70161_v - 2.5, entity.field_70165_t + 2.5, entity.field_70163_u + 2.5, entity.field_70161_v + 2.5);
            for (EntityItem item : entity.field_70170_p.func_72872_a(EntityItem.class, aabb)) {
                if (item == null) continue;
                double x = entity.field_70165_t - item.field_70165_t;
                double y = entity.field_70163_u - item.field_70163_u;
                double z = entity.field_70161_v - item.field_70161_v;
                Vec3d vec = new Vec3d(x, y, z).func_72432_b();
                item.field_70159_w = vec.field_72450_a * (double)0.2f;
                item.field_70181_x = vec.field_72448_b * (double)0.2f;
                item.field_70179_y = vec.field_72449_c * (double)0.2f;
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            NBTTagCompound nbt = stack.func_77978_p();
            if (!stack.func_77977_a().contains("ender") && stack.func_77977_a().contains("pouch")) {
                if (!playerIn.func_70093_af()) {
                    if (nbt.func_186857_a("playerID").equals(playerIn.func_110124_au()) || nbt.func_186857_a("playerID").equals(this.defaultUUID)) {
                        playerIn.openGui((Object)Main.instance, 3, worldIn, 0, 0, 0);
                    } else {
                        playerIn.func_70097_a(DamageSource.field_76376_m, 4.0f);
                    }
                } else if (nbt.func_186857_a("playerID").equals(this.defaultUUID)) {
                    nbt.func_186854_a("playerID", playerIn.func_110124_au());
                    stack.func_77982_d(nbt);
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"item.pouch.description.soulbinded", (Object[])new Object[0])));
                } else if (nbt.func_186857_a("playerID").equals(playerIn.func_110124_au())) {
                    nbt.func_186854_a("playerID", this.defaultUUID);
                    stack.func_77982_d(nbt);
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"item.pouch.description.unbinded", (Object[])new Object[0])));
                } else {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"item.pouch.description.wrong_owner", (Object[])new Object[0])));
                }
            } else if (stack.func_77977_a().contains("ender") && stack.func_77977_a().contains("pouch")) {
                playerIn.func_71007_a((IInventory)playerIn.func_71005_bN());
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184614_ca());
    }

    public NonNullList<ItemStack> getInventory(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        String tagName = stack.func_77977_a().substring(5, stack.func_77977_a().length());
        NBTTagList items = nbt.func_150295_c(tagName, 10);
        NonNullList inventory = NonNullList.func_191197_a((int)EnumHandler.PouchTypes.valueOf(tagName).getSlotCount(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("slot");
            if (slot < 0 || slot >= inventory.size()) continue;
            inventory.set(slot, (Object)new ItemStack(item));
        }
        return inventory;
    }

    public void setInventory(ItemStack stack, NonNullList<ItemStack> inv) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < inv.size(); ++i) {
            if (inv.get(i) == ItemStack.field_190927_a) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("slot", i);
            ((ItemStack)inv.get(i)).func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        String tagName = stack.func_77977_a().substring(5, stack.func_77977_a().length());
        stack.func_77978_p().func_74782_a(tagName, (NBTBase)items);
    }
}

