/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.gui;

import com.ancient.thaumicgadgets.gui.GuiButtonActiveText;
import com.ancient.thaumicgadgets.gui.GuiButtonListRL;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiFilterList
extends Gui {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("tg", "textures/gui/gui.png");
    private GuiTextField field;
    public String fieldText = "";
    private GuiButtonListRL[] lrButtons = new GuiButtonListRL[2];
    private GuiLabel lbl;
    private final FontRenderer fontRenderer;
    private int id;
    public int x;
    public int y;
    public int width;
    public int height;
    private int backTextureX;
    private int backTextureY;
    public List<String> displayList = Lists.newArrayList();
    public List<GuiButtonActiveText> buttons = Lists.newArrayList();
    public int textColor;
    public boolean isEnabled;
    public boolean visible;
    public int currentPage;
    private int maxPage;
    public int buttonsPerPage;
    private int choosedButton = -1;

    public GuiFilterList(int id, int x, int y, int width, int height, List<String> displayList, int buttonsPerPage, FontRenderer fontRenderer, int textColor, int backTextureX, int backTextureY) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.backTextureX = backTextureX;
        this.backTextureY = backTextureY;
        this.displayList = displayList;
        this.fontRenderer = fontRenderer;
        this.textColor = textColor;
        int divW = width / 2;
        int divH = height / 2;
        this.lrButtons[0] = new GuiButtonListRL(id + 1, x + divW - 10, y + height - 13, 8, 8, "left", TEXTURE, 198, 142, 256, 256);
        this.lrButtons[1] = new GuiButtonListRL(id + 2, x + divW + 10, y + height - 13, 8, 8, "right", TEXTURE, 174, 142, 256, 256);
        this.field = new GuiTextField(id + 4, fontRenderer, x + 6, y + 6, width - 25, 13);
        this.field.func_146195_b(true);
        this.buttonsPerPage = buttonsPerPage;
        this.maxPage = 0;
        if (!displayList.isEmpty()) {
            int q = 0;
            int z = 0;
            for (String s : displayList) {
                this.buttons.add(new GuiButtonActiveText(id + 5 + q, q, x + 5, y + 5 + this.field.field_146219_i + 5 + z * 16, width - 10, 13, s, 12072391, 0xE0E0E0));
                ++q;
                if (++z % buttonsPerPage != 0) continue;
                z = 0;
            }
            this.maxPage = Math.floorDiv(displayList.size(), buttonsPerPage);
        }
        this.visible = true;
    }

    public void drawFilterList(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            GlStateManager.func_179094_E();
            mc.func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            this.func_73729_b(this.x, this.y, this.backTextureX, this.backTextureY, this.width, this.height);
            this.func_73729_b(this.x + this.width - 16, this.y + 8, 200, 84, 9, 8);
            GlStateManager.func_179084_k();
            if (!this.displayList.isEmpty()) {
                this.lrButtons[0].func_191745_a(mc, mouseX, mouseY, partialTicks);
                this.lrButtons[1].func_191745_a(mc, mouseX, mouseY, partialTicks);
                this.lbl = new GuiLabel(this.fontRenderer, this.id + 3, this.x + this.width / 2 + 1, this.y + this.height - 12, 8, 8, this.textColor);
                this.lbl.func_175202_a(Integer.toString(this.currentPage));
                this.lbl.func_146159_a(mc, mouseX, mouseY);
                this.field.func_146194_f();
                int t = this.currentPage * this.buttonsPerPage;
                int q = 0;
                for (GuiButton guiButton : this.updateList()) {
                    if (q >= t && q < t + this.buttonsPerPage) {
                        guiButton.field_146124_l = true;
                        guiButton.field_146125_m = true;
                        guiButton.func_191745_a(mc, mouseX, mouseY, partialTicks);
                    } else {
                        guiButton.field_146124_l = false;
                        guiButton.field_146125_m = false;
                    }
                    ++q;
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    public void setCurrentPage(int value) {
        this.currentPage = value >= 0 ? (value <= this.maxPage ? value : this.maxPage) : 0;
    }

    public void incrPage() {
        if (this.currentPage < this.maxPage) {
            ++this.currentPage;
        } else if (this.currentPage == this.maxPage) {
            this.currentPage = 0;
        }
    }

    public void decrPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        } else if (this.currentPage == 0) {
            this.currentPage = this.maxPage;
        }
    }

    public GuiTextField getField() {
        return this.field;
    }

    public GuiLabel getLabel() {
        return this.lbl;
    }

    public GuiButtonListRL[] getLRButtons() {
        return this.lrButtons;
    }

    public List<GuiButtonActiveText> getButtons() {
        return this.buttons;
    }

    public int getId() {
        return this.id;
    }

    public int getChoosedButton() {
        return this.choosedButton;
    }

    public void setChoosedButton(int value) {
        if (value < 0) {
            value = -1;
        }
        if (value >= this.displayList.size()) {
            value = this.displayList.size() - 1;
        }
        this.choosedButton = value;
    }

    protected List<GuiButtonActiveText> updateList() {
        List<Integer> afterFilter = this.filterList();
        ArrayList buttons = Lists.newArrayList();
        int i = 0;
        int q = 0;
        for (GuiButtonActiveText b : this.buttons) {
            if (afterFilter.contains(i)) {
                b.field_146129_i = this.y + 5 + this.field.field_146219_i + 5 + q * 16;
                if (++q % this.buttonsPerPage == 0) {
                    q = 0;
                }
                b.field_146124_l = true;
                b.field_146125_m = true;
                buttons.add(b);
            } else {
                b.field_146124_l = false;
                b.field_146125_m = false;
            }
            ++i;
        }
        return buttons;
    }

    public List<Integer> filterList() {
        ArrayList dummyList = Lists.newArrayList();
        if (this.fieldText.equals("")) {
            for (int q = 0; q < this.displayList.size(); ++q) {
                dummyList.add(q);
            }
            return dummyList;
        }
        if (!this.displayList.isEmpty()) {
            for (int q = 0; q < this.displayList.size(); ++q) {
                if (!this.displayList.get(q).toLowerCase().contains(this.fieldText.toLowerCase())) continue;
                dummyList.add(q);
            }
        }
        return dummyList;
    }
}

