/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.entity.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityObserver
extends EntityMob {
    protected static final DataParameter<Byte> OBS_FLAGS = EntityDataManager.func_187226_a(EntityObserver.class, (DataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockPos boundOrigin;

    public EntityObserver(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_70105_a(0.9f, 1.5f);
        this.field_70728_aV = 100;
        this.field_70765_h = new AIMoveControl(this);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityObserver.class}));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public float func_70047_e() {
        return 1.4f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.5);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OBS_FLAGS, (Object)0);
    }

    public static void registerFixesObs(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityObserver.class);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    private boolean getObsFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(OBS_FLAGS);
        return (i & mask) != 0;
    }

    private void setObsFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(OBS_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(OBS_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getObsFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setObsFlag(1, charging);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!super.func_70652_k(entityIn)) {
            return false;
        }
        if (entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100));
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 2));
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200));
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100));
        }
        return true;
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityObserver.this.func_70605_aq().func_75640_a() && EntityObserver.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityObserver.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityObserver.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityObserver.this.field_70146_Z.nextInt(15) - 7, EntityObserver.this.field_70146_Z.nextInt(11) - 5, EntityObserver.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityObserver.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityObserver.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityObserver.this.func_70638_az() != null) break;
                EntityObserver.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityObserver.this.func_70638_az() != null && !EntityObserver.this.func_70605_aq().func_75640_a() && EntityObserver.this.field_70146_Z.nextInt(7) == 0) {
                return EntityObserver.this.func_70068_e((Entity)EntityObserver.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityObserver.this.func_70605_aq().func_75640_a() && EntityObserver.this.isCharging() && EntityObserver.this.func_70638_az() != null && EntityObserver.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityObserver.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityObserver.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityObserver.this.setCharging(true);
            EntityObserver.this.func_184185_a(SoundEvents.field_187597_B, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            EntityObserver.this.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityObserver.this.func_70638_az();
            if (EntityObserver.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                EntityObserver.this.func_70652_k((Entity)entitylivingbase);
                EntityObserver.this.setCharging(false);
            } else {
                double d0 = EntityObserver.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    EntityObserver.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityObserver obs) {
            super((EntityLiving)obs);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityObserver.this.field_70165_t;
                double d1 = this.field_75647_c - EntityObserver.this.field_70163_u;
                double d2 = this.field_75644_d - EntityObserver.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityObserver.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityObserver.this.field_70159_w *= 0.5;
                    EntityObserver.this.field_70181_x *= 0.5;
                    EntityObserver.this.field_70179_y *= 0.5;
                } else {
                    EntityObserver.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityObserver.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityObserver.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityObserver.this.func_70638_az() == null) {
                        EntityObserver.this.field_70761_aq = EntityObserver.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityObserver.this.field_70159_w, (double)EntityObserver.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityObserver.this.func_70638_az().field_70165_t - EntityObserver.this.field_70165_t;
                        double d5 = EntityObserver.this.func_70638_az().field_70161_v - EntityObserver.this.field_70161_v;
                        EntityObserver.this.field_70761_aq = EntityObserver.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

