/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.blocks.plants;

import com.ancient.thaumicgadgets.blocks.BlockBase;
import com.ancient.thaumicgadgets.util.ITGPlant;
import com.ancient.thaumicgadgets.util.handlers.PlantsManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlant
extends BlockBase
implements ITGPlant {
    private static final int maxAge = 7;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final AxisAlignedBB[][] CROPS_AABB = new AxisAlignedBB[][]{{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)}, {new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0)}};
    private final int floorCount;
    private int growTicks;
    private final int growTicksChangeAge;
    private int plantTicks;
    private final int plantTicksTime;
    private final boolean mustPlant;
    private long lastTickTime;
    private final int maxLightLvl;
    private final int minLightLvl;

    public BlockPlant(String name, int growTicksChangeAge, boolean mustPlant, int plantTicksTime, int minLightLvl, int maxLightLvl, int maxAge, int floorCount) {
        super(name, Material.field_151585_k);
        this.floorCount = floorCount;
        this.growTicksChangeAge = growTicksChangeAge;
        this.mustPlant = mustPlant;
        this.plantTicksTime = plantTicksTime;
        this.maxLightLvl = maxLightLvl;
        this.minLightLvl = minLightLvl;
        this.func_149711_c(0.0f);
        this.func_149713_g(0);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int age = this.getAge(state);
        return age < this.getMaxAge() ? this.getSeed() : this.getCrop();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175697_a(pos, 3)) {
            if (world.func_175671_l(pos) <= 5) {
                IBlockState st = world.func_180495_p(pos);
                int i = this.getAge(st);
                if (i < this.getMaxAge()) {
                    this.growTicks = (int)((long)this.growTicks + (world.func_82737_E() - this.lastTickTime));
                    if (this.growTicks >= this.growTicksChangeAge) {
                        this.growTicks = 0;
                        world.func_175656_a(pos, this.withAge(i + 1));
                    }
                } else if (i == this.getMaxAge() && this.mustPlant) {
                    this.plantTicks = (int)((long)this.plantTicks + (world.func_82737_E() - this.lastTickTime));
                    if (this.plantTicks >= this.plantTicksTime) {
                        this.plantTicks = 0;
                        this.plantFlower(world, pos, st);
                    }
                }
                this.lastTickTime = world.func_82737_E();
            }
            world.func_180497_b(pos, state.func_177230_c(), this.func_149738_a(world), 0);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K && pos.equals((Object)fromPos.func_177984_a()) && world.func_180495_p(fromPos).func_177230_c() == Blocks.field_150350_a) {
            world.func_175655_b(pos, true);
        }
    }

    protected void plantFlower(World world, BlockPos pos, IBlockState state) {
        Iterable poses = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-3, -2, -3), (BlockPos)pos.func_177982_a(3, 2, 3));
        for (BlockPos p : poses) {
            IBlockState st = world.func_180495_p(p);
            IBlockState st1 = world.func_180495_p(p.func_177984_a());
            if (!this.canPlacePlant(world, p)) continue;
            world.func_175656_a(p, PlantsManager.INSTANCE.getChild(this).getPlant().func_176223_P());
            return;
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            world.func_180497_b(pos, state.func_177230_c(), this.func_149738_a(world), 0);
        }
    }

    public int func_149738_a(World worldIn) {
        return 40;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            int i = this.getAge(state);
            if (i < this.getMaxAge()) {
                if (playerIn.func_184586_b(hand).func_77973_b().equals(Items.field_151100_aR) && playerIn.func_184586_b(hand).func_77960_j() == 15) {
                    worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        playerIn.func_184586_b(hand).func_190918_g(1);
                    }
                    return true;
                }
            } else if (this.isMaxAge(state) && this.mustPlant && playerIn.func_184586_b(hand).func_77973_b().equals(Items.field_151100_aR) && playerIn.func_184586_b(hand).func_77960_j() == 15) {
                this.plantTicks = 0;
                this.plantFlower(worldIn, pos, state);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (PlantsManager.INSTANCE.hasChild(this)) {
            return super.func_176196_c(worldIn, pos) && this.canPlacePlant(worldIn, pos);
        }
        return super.func_176196_c(worldIn, pos);
    }

    public boolean canPlacePlant(World world, BlockPos pos) {
        IBlockState stateD = world.func_180495_p(pos.func_177977_b());
        IBlockState stateC = world.func_180495_p(pos);
        return (stateD.func_177230_c() instanceof BlockGrass || stateD.func_177230_c() instanceof BlockDirt) && stateC.func_177230_c() instanceof BlockAir && world.func_175699_k(pos) >= this.getMinLightLvl() && world.func_175699_k(pos) <= this.getMaxLightLvl();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer != null && placer instanceof EntityPlayer) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge())));
        }
        this.lastTickTime = worldIn.func_82737_E();
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    @Override
    public Item getSeed() {
        return PlantsManager.INSTANCE.getSeed(this);
    }

    @Override
    public Item getCrop() {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public int getMinLightLvl() {
        return this.minLightLvl;
    }

    @Override
    public int getMaxLightLvl() {
        return this.maxLightLvl;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[this.floorCount - 1][(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

