/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.armour.primal;

import com.ancient.thaumicgadgets.armour.ArmorBase;
import com.ancient.thaumicgadgets.armour.primal.ArmorPrimalModel;
import com.ancient.thaumicgadgets.armour.primal.ArmorPrimalUpgraded;
import com.ancient.thaumicgadgets.init.ModEnchantments;
import com.ancient.thaumicgadgets.proxy.ClientProxy;
import com.ancient.thaumicgadgets.util.ICheckEnchantment;
import com.ancient.thaumicgadgets.util.IFunctionLibrary;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorPrimal
extends ArmorBase
implements ICheckEnchantment {
    private int regenCount = 2;
    private long lastTick = 0L;
    private int period = 100;
    private int mode = 0;

    public ArmorPrimal(String name, ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(name, materialIn, renderIndexIn, equipmentSlotIn);
    }

    public void OnPlayerHurt(EntityPlayer player, DamageSource source, float amount) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int mode = 0;
        if (stack.func_77942_o()) {
            mode = stack.func_77978_p().func_74762_e("mode");
        }
        tooltip.add(I18n.func_135052_a((String)"item.primal.description", (Object[])new Object[0]) + "\u00a7" + IFunctionLibrary.getAspectFromMode(mode).getChatcolor() + IFunctionLibrary.getAspectFromMode(mode).getName());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("mode", this.mode);
            stack.func_77982_d(nbt);
        }
    }

    public void changeItemMode(EntityPlayer player, ItemStack stack, int slotId) {
        ArmorPrimal ar = (ArmorPrimal)stack.func_77973_b();
        ItemStack is = new ItemStack(stack.func_77973_b());
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("mode", stack.func_77978_p().func_74762_e("mode") + 1);
        is.func_77982_d(nbt);
        if (is.func_77978_p().func_74762_e("mode") > 5) {
            is.func_77978_p().func_74768_a("mode", 0);
        }
        if (stack.func_77973_b() instanceof ArmorPrimalUpgraded) {
            NBTTagList list = stack.func_77978_p().func_150295_c("primalInventory", 10);
            is.func_77978_p().func_74782_a("primalInventory", (NBTBase)list);
        }
        player.field_71071_by.field_70460_b.set(slotId, (Object)is);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (itemStack.func_77952_i() > 0) {
            this.setDamage(itemStack, -1);
        }
        boolean mode = false;
        if (itemStack.func_77973_b() instanceof ArmorPrimal) {
            this.canApplyEchantment(itemStack, 0, 5);
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74762_e("mode") == 2) {
            boolean canApply = true;
            Map enc = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
            for (Map.Entry e : enc.entrySet()) {
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.REGEN_PRIMAL, (ItemStack)itemStack) <= 0) continue;
                canApply = false;
                this.regenTick(world, player, itemStack);
            }
            if (canApply) {
                itemStack.func_77966_a(ModEnchantments.REGEN_PRIMAL, 1);
                NBTTagCompound nbt = itemStack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                nbt.func_74772_a("lastTick", world.func_82737_E());
                itemStack.func_77982_d(nbt);
            }
        }
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74762_e("mode") == 5) {
            this.canApplyEchantment(itemStack, Enchantments.field_92091_k, 5);
        }
    }

    private void regenTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        long lastTick = nbt.func_74763_f("lastTick");
        if (lastTick + (long)this.period < world.func_82737_E()) {
            player.func_70691_i((float)this.regenCount);
            nbt.func_74772_a("lastTick", world.func_82737_E());
            stack.func_77982_d(nbt);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemArmor) {
            ArmorPrimalModel armorModel = ClientProxy.ARMOR_PRIMAL_MODEL;
            ArmorPrimalModel armorModelLegs = ClientProxy.ARMOR_PRIMAL_MODEL_LEGS;
            armorModel.field_78116_c.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            armorModel.field_178720_f.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            armorModel.field_78115_e.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.CHEST;
            armorModel.field_178723_h.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            armorModel.field_178724_i.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            armorModelLegs.field_178721_j.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            armorModelLegs.field_178722_k.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            armorModel.field_78117_n = _default.field_78117_n;
            armorModel.field_78093_q = _default.field_78093_q;
            armorModel.field_78091_s = _default.field_78091_s;
            armorModel.field_187076_m = _default.field_187076_m;
            armorModel.field_187075_l = _default.field_187075_l;
            armorModelLegs.field_78117_n = _default.field_78117_n;
            armorModelLegs.field_78093_q = _default.field_78093_q;
            armorModelLegs.field_78091_s = _default.field_78091_s;
            armorModelLegs.field_187076_m = _default.field_187076_m;
            armorModelLegs.field_187075_l = _default.field_187075_l;
            return armorModel;
        }
        return null;
    }
}

