/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.tiles;

import ca.teamdman.zensummoning.ZenSummoning;
import ca.teamdman.zensummoning.common.summoning.MobInfo;
import ca.teamdman.zensummoning.common.summoning.SummoningAttempt;
import ca.teamdman.zensummoning.common.summoning.SummoningDirector;
import ca.teamdman.zensummoning.common.summoning.SummoningInfo;
import ca.teamdman.zensummoning.util.WeightedRandomBag;
import com.google.common.collect.ImmutableList;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileAltar
extends TileEntity
implements ITickable {
    public final int TIME_TO_SPAWN = 100;
    private final ItemStackHandler clientInventory = new ItemStackHandler();
    private final ItemStackHandler inventory = new ItemStackHandler(SummoningDirector.getStackLimit()){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileAltar.this.field_145850_b.func_184138_a(TileAltar.this.field_174879_c, TileAltar.this.field_145850_b.func_180495_p(TileAltar.this.field_174879_c), TileAltar.this.field_145850_b.func_180495_p(TileAltar.this.field_174879_c), 3);
            TileAltar.this.func_70296_d();
        }
    };
    public int renderTick = -1;
    private int summonCountdown = -1;
    private SummoningInfo summonInfo;

    public void func_73660_a() {
        if (!this.isSummoning()) {
            if (this.renderTick > -1) {
                --this.renderTick;
            }
            return;
        }
        --this.summonCountdown;
        ++this.renderTick;
        if (this.summonCountdown > 0) {
            return;
        }
        this.summonFinish();
    }

    public boolean isSummoning() {
        return this.summonInfo != null && this.summonCountdown >= 0;
    }

    private void summonFinish() {
        ZenSummoning.log("summonFinish");
        this.summonCountdown = -1;
        if (this.field_145850_b.field_72995_K) {
            this.summonInfo = null;
            return;
        }
        for (MobInfo mobInfo : this.summonInfo.getMobs()) {
            for (int i = 0; i < mobInfo.getCount(); ++i) {
                Entity mob = EntityList.func_188429_b((ResourceLocation)mobInfo.getMob(), (World)this.field_145850_b);
                if (mob == null) {
                    return;
                }
                mob.func_70020_e(mobInfo.getData());
                mob.func_70107_b((double)(this.func_174877_v().func_177958_n() + mobInfo.getOffset().func_177958_n() + this.field_145850_b.field_73012_v.nextInt(Math.abs(mobInfo.getSpread().func_177958_n() * 2) + 1) - Math.abs(mobInfo.getSpread().func_177958_n())), (double)(this.func_174877_v().func_177956_o() + mobInfo.getOffset().func_177956_o() + this.field_145850_b.field_73012_v.nextInt(Math.abs(mobInfo.getSpread().func_177956_o() * 2) + 1) - Math.abs(mobInfo.getSpread().func_177956_o())), (double)(this.func_174877_v().func_177952_p() + mobInfo.getOffset().func_177952_p() + this.field_145850_b.field_73012_v.nextInt(Math.abs(mobInfo.getSpread().func_177952_p() * 2) + 1) - Math.abs(mobInfo.getSpread().func_177952_p())));
                this.field_145850_b.func_72838_d(mob);
            }
        }
        this.summonInfo = null;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_191249_bs, SoundCategory.BLOCKS, 0.5f, 1.0f);
    }

    private Optional<SummoningInfo> getSummonInfo(ItemStack catalyst) {
        WeightedRandomBag bag = new WeightedRandomBag();
        SummoningDirector.getSummonInfos().stream().filter(x -> this.meetsCriteria((SummoningInfo)x, catalyst)).forEach(x -> bag.addEntry(x, x.getWeight()));
        if (bag.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(bag.getRandom());
    }

    public SummoningAttempt attemptSummon(ItemStack catalyst) {
        ZenSummoning.log("summonStart");
        SummoningAttempt attempt = new SummoningAttempt(CraftTweakerMC.getIWorld((World)this.field_145850_b), CraftTweakerMC.getIBlockPos((BlockPos)this.field_174879_c));
        if (this.isSummoning()) {
            attempt.setSuccess(false);
            attempt.setMessage("chat.zensummoning.busy");
            return attempt;
        }
        Optional<SummoningInfo> infoMatch = this.getSummonInfo(catalyst);
        if (!infoMatch.isPresent()) {
            attempt.setSuccess(false);
            attempt.setMessage(this.getAssumedErrorMessage(catalyst));
            return attempt;
        }
        SummoningInfo info = infoMatch.get();
        Optional<HashMap<Integer, Integer>> slotsMatch = this.getIngredientsToConsume(info);
        if (!slotsMatch.isPresent()) {
            attempt.setSuccess(false);
            attempt.setMessage("chat.zensummoning.unknown_error");
            return attempt;
        }
        info.getMutator().accept(attempt);
        if (!attempt.isSuccess()) {
            return attempt;
        }
        this.beginSummoning(info);
        slotsMatch.get().forEach((slot, count) -> this.inventory.extractItem(slot.intValue(), count.intValue(), false));
        if (info.isCatalystConsumed()) {
            catalyst.func_190918_g(info.getCatalyst().getAmount());
        }
        return attempt;
    }

    public Optional<SummoningAttempt> attemptWorldSummon() {
        AxisAlignedBB itemRange = new AxisAlignedBB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).func_186670_a(this.field_174879_c);
        for (EntityItem ent : this.field_145850_b.func_72872_a(EntityItem.class, itemRange)) {
            SummoningAttempt attempt = this.attemptSummon(ent.func_92059_d());
            if (!attempt.isSuccess()) continue;
            return Optional.of(attempt);
        }
        return Optional.empty();
    }

    private Optional<HashMap<Integer, Integer>> getIngredientsToConsume(SummoningInfo info) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (IIngredient reagent : info.getReagents()) {
            int remaining = reagent.getAmount();
            for (int slot = 0; slot < this.inventory.getSlots() && remaining > 0; ++slot) {
                ItemStack slotStack = this.inventory.getStackInSlot(slot);
                int available = slotStack.func_190916_E() - map.getOrDefault(slot, 0);
                if (!reagent.matches(CraftTweakerMC.getIItemStack((ItemStack)slotStack)) || available <= 0) continue;
                map.merge(slot, Math.min(remaining, available), Integer::sum);
                remaining -= available;
            }
            if (remaining <= 0) continue;
            return Optional.empty();
        }
        return Optional.of(map);
    }

    private boolean meetsCriteria(SummoningInfo info, ItemStack handStack) {
        if (!info.getCatalyst().matches(CraftTweakerMC.getIItemStack((ItemStack)handStack))) {
            return false;
        }
        if (info.getCatalyst().getAmount() > handStack.func_190916_E()) {
            return false;
        }
        return this.getIngredientsToConsume(info).isPresent();
    }

    private String getAssumedErrorMessage(ItemStack handStack) {
        String msg = "chat.zensummoning.no_match";
        int mask = 0;
        for (SummoningInfo info : SummoningDirector.getSummonInfos()) {
            if (!info.getCatalyst().amount(1).matches(CraftTweakerMC.getIItemStack((ItemStack)handStack))) continue;
            mask |= 1;
            if (info.getCatalyst().getAmount() >= handStack.func_190916_E()) continue;
            mask |= 0x10;
        }
        if (mask == 0) {
            return "chat.zensummoning.no_match";
        }
        if (mask == 1) {
            return "chat.zensummoning.unsatisfied_hand";
        }
        return "chat.zensummoning.unsatisfied";
    }

    private void beginSummoning(SummoningInfo info) {
        this.summonInfo = info;
        this.summonCountdown = 100;
        this.renderTick = 0;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_193784_dd, SoundCategory.BLOCKS, 0.5f, 1.0f);
    }

    public ItemStack pushStack(ItemStack stack) {
        ItemStack rtn = stack;
        for (int slot = 0; slot < this.inventory.getSlots() && !rtn.func_190926_b(); ++slot) {
            rtn = this.inventory.insertItem(slot, rtn, false);
        }
        return rtn;
    }

    public ItemStack popStack() {
        for (int slot = this.inventory.getSlots() - 1; slot >= 0; --slot) {
            ItemStack rtn = this.inventory.getStackInSlot(slot);
            if (rtn.func_190926_b()) continue;
            return this.inventory.extractItem(slot, rtn.func_190916_E(), false);
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public ImmutableList<ItemStack> getClientStacks() {
        return this.getStacksFromInventory(this.clientInventory);
    }

    private ImmutableList<ItemStack> getStacksFromInventory(ItemStackHandler handler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            builder.add((Object)stack);
        }
        return builder.build();
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.renderTick = compound.func_74762_e("renderTick");
        this.summonCountdown = compound.func_74762_e("summonCountdown");
        if (compound.func_74764_b("summonInfo")) {
            this.summonInfo = SummoningInfo.fromNBT(compound.func_74775_l("summonInfo"));
        } else if (!this.isSummoning()) {
            this.clientInventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("renderTick", this.renderTick);
        compound.func_74768_a("summonCountdown", this.summonCountdown);
        if (this.isSummoning()) {
            compound.func_74782_a("summonInfo", (NBTBase)this.summonInfo.serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound comp = new NBTTagCompound();
        this.func_189515_b(comp);
        return new SPacketUpdateTileEntity(this.field_174879_c, 255, comp);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nullable Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }
}

