/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile;

import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nullable;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementMysticalMechanics;
import modulardiversity.tile.base.TileEntityMysticalMechanics;
import modulardiversity.util.ICraftingResourceHolder;
import mysticalmechanics.api.DefaultMechCapability;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileMysticalMechanicsOutput
extends TileEntityMysticalMechanics
implements ITickable {
    public int keepPowerTicks;

    @Override
    protected IMechCapability initCapability() {
        return new DefaultMechCapability(){

            public void setPower(double value, EnumFacing from) {
                if (from == null) {
                    super.setPower(value, from);
                }
            }

            public void onPowerChange() {
                super.onPowerChange();
                TileMysticalMechanicsOutput.this.updateNearby();
                TileMysticalMechanicsOutput.this.func_70296_d();
            }

            public boolean isInput(EnumFacing from) {
                return false;
            }

            public boolean isOutput(EnumFacing from) {
                return true;
            }
        };
    }

    @Override
    public boolean consume(RequirementMysticalMechanics.ResourceToken token, boolean doConsume) {
        return false;
    }

    @Override
    public boolean generate(RequirementMysticalMechanics.ResourceToken token, boolean doGenerate) {
        if (doGenerate && !this.broken) {
            this.capability.setPower(token.getLevelOutput(), null);
            this.keepPowerTicks = token.getTime();
        }
        token.setRequiredlevelMet();
        return true;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.broken = true;
        this.capability.setPower(0.0, null);
        this.updateNearby();
    }

    public void updateNearby() {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
            if (t == null || !t.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, f.func_176734_d())) continue;
            ((IMechCapability)t.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, f.func_176734_d())).setPower(this.capability.getPower(f), f.func_176734_d());
            t.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.keepPowerTicks = Math.max(0, this.keepPowerTicks - 1);
            if (this.keepPowerTicks <= 0 && this.capability.getPower(null) > 0.0) {
                this.capability.setPower(0.0, null);
            }
        }
    }

    @Nullable
    public MachineComponent provideComponent() {
        return new MachineComponents.MysticalMechanicsHatch(MachineComponent.IOType.OUTPUT){

            public ICraftingResourceHolder<RequirementMysticalMechanics.ResourceToken> getContainerProvider() {
                return TileMysticalMechanicsOutput.this;
            }
        };
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        DefaultMechCapability capability = (DefaultMechCapability)this.capability;
        capability.power = compound.func_74769_h("mech_power");
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        DefaultMechCapability capability = (DefaultMechCapability)this.capability;
        compound.func_74780_a("mech_power", capability.power);
    }
}

