/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.renderer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import modulardiversity.jei.ingredients.Position;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;

public class RendererPosition
implements IIngredientRenderer<Position> {
    private void registerDrawables() {
    }

    public void render(Minecraft minecraft, int i, int i1, @Nullable Position ingredient) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.registerDrawables();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    public List<String> getTooltip(Minecraft minecraft, Position ingredient, ITooltipFlag tooltipFlag) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(ingredient.getDisplayName());
        if (ingredient.getxMin() != 0.0f || ingredient.getxMax() != 0.0f) {
            this.addCoordinate(tooltip, ingredient.getxMin(), ingredient.getxMax(), "x");
        }
        if (ingredient.getyMin() != 0.0f || ingredient.getyMax() != 0.0f) {
            this.addCoordinate(tooltip, ingredient.getyMin(), ingredient.getyMax(), "y");
        }
        if (ingredient.getzMin() != 0.0f || ingredient.getzMax() != 0.0f) {
            this.addCoordinate(tooltip, ingredient.getzMin(), ingredient.getzMax(), "z");
        }
        if (ingredient.getDistanceMax() > 0.0f) {
            this.addDistance(tooltip, ingredient.getDistanceMin(), ingredient.getDistanceMax());
        }
        ingredient.getAnchor().addTooltip(tooltip);
        return tooltip;
    }

    protected void addCoordinate(List<String> tooltip, float min, float max, String key) {
        if (!Float.isInfinite(min) || !Float.isInfinite(max)) {
            tooltip.add(I18n.func_135052_a((String)this.getKey(min, max, key), (Object[])new Object[]{Float.valueOf(min), Float.valueOf(max)}));
        }
    }

    protected void addDistance(List<String> tooltip, float min, float max) {
        if (min > 0.0f || !Float.isInfinite(max)) {
            tooltip.add(I18n.func_135052_a((String)this.getDistanceKey(min, max), (Object[])new Object[]{Float.valueOf(min), Float.valueOf(max)}));
        }
    }

    private String getKey(float min, float max, String key) {
        if (Float.isInfinite(min)) {
            return "tooltip." + key + ".less";
        }
        if (Float.isInfinite(max)) {
            return "tooltip." + key + ".greater";
        }
        if (max == min) {
            return "tooltip." + key + ".exact";
        }
        return "tooltip." + key;
    }

    private String getDistanceKey(float min, float max) {
        if (min <= 0.0f) {
            return "tooltip.distance.less";
        }
        if (Float.isInfinite(max)) {
            return "tooltip.distance.greater";
        }
        if (max == min) {
            return "tooltip.distance.exact";
        }
        return "tooltip.distance";
    }
}

