/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentMysticalMechanics;
import modulardiversity.jei.ingredients.MysticalMechanics;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;

public class RequirementMysticalMechanics
extends RequirementConsumePerTick<MysticalMechanics, ResourceToken> {
    private double requiredLevelMin;
    private double requiredLevelMax;
    private double levelOutput;
    private int time;

    public RequirementMysticalMechanics(MachineComponent.IOType actionType, double requiredLevelMin, double requiredLevelMax) {
        this(actionType, requiredLevelMin, requiredLevelMax, 0.0, 0);
    }

    public RequirementMysticalMechanics(MachineComponent.IOType actionType, double levelOutput, int time) {
        this(actionType, 0.0, 0.0, levelOutput, time);
    }

    public RequirementMysticalMechanics(MachineComponent.IOType actionType, double requiredLevelMin, double requiredLevelMax, double levelOutput, int time) {
        super(ComponentType.Registry.getComponent((String)"mysticalmechanics"), actionType);
        this.requiredLevelMin = requiredLevelMin;
        this.requiredLevelMax = requiredLevelMax;
        this.levelOutput = levelOutput;
        this.time = time;
    }

    public double getRequiredLevelMin() {
        return this.requiredLevelMin;
    }

    public double getRequiredLevelMax() {
        return this.requiredLevelMax;
    }

    public double getLevelOutput() {
        return this.levelOutput;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredLevelMin, this.requiredLevelMax, this.levelOutput, this.time);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("mysticalmechanics") && component instanceof MachineComponents.MysticalMechanicsHatch && component.getIOType() == this.getActionType();
    }

    public ComponentRequirement<MysticalMechanics> deepCopy() {
        return new RequirementMysticalMechanics(this.getActionType(), this.requiredLevelMin, this.requiredLevelMax, this.levelOutput, this.time);
    }

    public ComponentRequirement<MysticalMechanics> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementMysticalMechanics(this.getActionType(), Misc.applyModifiers(modifiers, "mysticalmechanics_min", this.getActionType(), this.requiredLevelMin, false), Misc.applyModifiers(modifiers, "mysticalmechanics_max", this.getActionType(), this.requiredLevelMax, false), Misc.applyModifiers(modifiers, "mysticalmechanics", this.getActionType(), this.levelOutput, false), this.time);
    }

    public ComponentRequirement.JEIComponent<MysticalMechanics> provideJEIComponent() {
        return new JEIComponentMysticalMechanics(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private double requiredLevelMin;
        private double requiredLevelMax;
        private double levelOutput;
        private boolean requiredlevelMet;
        private int time;

        public ResourceToken(double requiredLevelMin, double requiredLevelMax, double levelOutput, int time) {
            this.requiredLevelMin = requiredLevelMin;
            this.requiredLevelMax = requiredLevelMax;
            this.levelOutput = levelOutput;
            this.time = time;
        }

        public double getRequiredLevelMin() {
            return this.requiredLevelMin;
        }

        public double getRequiredLevelMax() {
            return this.requiredLevelMax;
        }

        public double getLevelOutput() {
            return this.levelOutput;
        }

        public int getTime() {
            return this.time;
        }

        public void setRequiredlevelMet() {
            this.requiredlevelMet = true;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.requiredLevelMin = Misc.applyModifiers(modifiers, "mysticalmechanics_min", ioType, this.requiredLevelMin, false);
            this.requiredLevelMax = Misc.applyModifiers(modifiers, "mysticalmechanics_max", ioType, this.requiredLevelMax, false);
            this.levelOutput = Misc.applyModifiers(modifiers, "mysticalmechanics", ioType, this.levelOutput, false);
        }

        @Override
        public boolean isEmpty() {
            return this.requiredlevelMet;
        }
    }
}

