/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumeOnce;
import modulardiversity.jei.JEIComponentMana;
import modulardiversity.jei.ingredients.Mana;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;

public class RequirementMana
extends RequirementConsumeOnce<Mana, ResourceToken> {
    public int requiredMana;

    public RequirementMana(MachineComponent.IOType actionType, int requiredMana) {
        super(ComponentType.Registry.getComponent((String)"mana"), actionType);
        this.requiredMana = requiredMana;
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("mana") && component instanceof MachineComponents.ManaHatch && component.getIOType() == this.getActionType();
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredMana);
    }

    public ComponentRequirement deepCopy() {
        return new RequirementMana(this.getActionType(), this.requiredMana);
    }

    public ComponentRequirement<Mana> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementMana(this.getActionType(), Misc.applyModifiers(modifiers, "mana", this.getActionType(), this.requiredMana, false));
    }

    public ComponentRequirement.JEIComponent<Mana> provideJEIComponent() {
        return new JEIComponentMana(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private int mana;

        public ResourceToken(int mana) {
            this.mana = mana;
        }

        public int getMana() {
            return this.mana;
        }

        public void setMana(int mana) {
            this.mana = mana;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.mana = Misc.applyModifiers(modifiers, "mana", ioType, this.mana, false);
        }

        @Override
        public boolean isEmpty() {
            return this.mana <= 0;
        }
    }
}

