/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import modulardiversity.components.requirements.IAnchorTypeDeserializer;
import modulardiversity.util.JsonUtil;
import modulardiversity.util.MachineList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class AnchorType {
    static Map<String, IAnchorTypeDeserializer> typeMap = new HashMap<String, IAnchorTypeDeserializer>();
    public static final AnchorType DEFAULT = new Offset();

    public static void registerType(String identifier, IAnchorTypeDeserializer deserializer) {
        typeMap.put(identifier, deserializer);
    }

    public static AnchorType get(JsonObject json) {
        String identifier = JsonUtil.get(json, "type", "default");
        IAnchorTypeDeserializer deserializer = typeMap.get(identifier);
        if (deserializer != null) {
            return deserializer.deserialize(json);
        }
        return null;
    }

    public abstract Vec3d getAnchorPoint(World var1, BlockPos var2);

    public abstract void addTooltip(List<String> var1);

    static {
        AnchorType.registerType("default", json -> DEFAULT);
        AnchorType.registerType("spawn", json -> new Spawn());
        AnchorType.registerType("anchor", json -> {
            String identifier = JsonUtil.get(json, "identifier", "default");
            return new Anchor(identifier);
        });
        AnchorType.registerType("offset", json -> {
            double x = JsonUtil.get(json, "x", 0.0);
            double y = JsonUtil.get(json, "y", 0.0);
            double z = JsonUtil.get(json, "z", 0.0);
            return new Offset(x, y, z);
        });
    }

    public static class Spawn
    extends AnchorType {
        @Override
        public Vec3d getAnchorPoint(World world, BlockPos pos) {
            BlockPos spawn = world.func_175694_M();
            return new Vec3d((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
        }

        @Override
        public void addTooltip(List<String> tooltip) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.anchor.spawn", (Object[])new Object[0]));
        }
    }

    public static class Offset
    extends AnchorType {
        double x;
        double y;
        double z;

        public Offset() {
        }

        public Offset(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public Vec3d getAnchorPoint(World world, BlockPos pos) {
            return new Vec3d(this.x, this.y, this.z);
        }

        @Override
        public void addTooltip(List<String> tooltip) {
            if (this.x != 0.0 || this.y != 0.0 || this.z != 0.0) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.anchor.offset", (Object[])new Object[]{this.x, this.y, this.z}));
            }
        }
    }

    public static class Anchor
    extends AnchorType {
        private String identifier;

        public Anchor(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public Vec3d getAnchorPoint(World world, BlockPos pos) {
            BlockPos nearestPos = MachineList.getNearest(world, pos, this.identifier);
            if (nearestPos != null) {
                return new Vec3d((double)nearestPos.func_177958_n(), (double)nearestPos.func_177956_o(), (double)nearestPos.func_177952_p());
            }
            return null;
        }

        @Override
        public void addTooltip(List<String> tooltip) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.anchor.anchor", (Object[])new Object[]{this.identifier}));
        }
    }
}

