/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RandomCollector {
    private HashMap<Object, Integer> collector;
    int maxRandomNumber;

    public RandomCollector() {
        this.collector = new HashMap();
    }

    public RandomCollector(HashMap<Object, Integer> collector, int maxRandomNumber) {
        this.collector = collector;
        this.maxRandomNumber = maxRandomNumber;
    }

    public void addObject(Object obj, int chance) {
        this.collector.put(obj, chance);
        this.maxRandomNumber += chance;
    }

    public Object getRandomObject() {
        if (this.maxRandomNumber != 0) {
            int random = 1 + new Random().nextInt(this.maxRandomNumber);
            int col = 0;
            for (Map.Entry<Object, Integer> entry : this.collector.entrySet()) {
                if (random > col && random <= col + entry.getValue()) {
                    return entry.getKey();
                }
                col += entry.getValue().intValue();
            }
        }
        return null;
    }

    public List<Object> getRandomObjects(int count) {
        RandomCollector rc = this.clone();
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.maxRandomNumber != 0 && count != 0) {
            Object obj;
            for (int i = 0; i < count && (obj = rc.getRandomObject()) != null; ++i) {
                rc.removeObject(obj);
                list.add(obj);
            }
        }
        return list;
    }

    public void removeObject(Object obj) {
        if (this.collector.containsKey(obj)) {
            int n = this.collector.remove(obj);
            this.maxRandomNumber -= n;
        }
    }

    public int getObjectsCount() {
        return this.collector.size();
    }

    protected RandomCollector clone() {
        return new RandomCollector((HashMap)this.collector.clone(), this.maxRandomNumber);
    }

    public HashMap<Object, Integer> getCollector() {
        return this.collector;
    }

    public boolean isEmpty() {
        return this.getObjectsCount() == 0;
    }
}

