/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedextraction.Wrapper;
import ru.poopycoders.improvedextraction.custom.customrecipes.cuttingtable.CuttingTableManager;
import ru.poopycoders.improvedextraction.custom.customrecipes.cuttingtable.CuttingTableRecipe;

public class TileEntityCuttingTable
extends TileEntity {
    private static final int CLICK_DELAY = 1000;
    private ItemStack item = ItemStack.field_190927_a;
    private CuttingTableRecipe tableResult;
    private int clickCount = 0;
    private long lastClickTime = 0L;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Item")) {
            this.setItem(new ItemStack(tag.func_74775_l("Item")));
        } else {
            this.setItem(ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (!this.item.func_190926_b()) {
            tag.func_74782_a("Item", (NBTBase)this.item.serializeNBT());
        }
        return super.func_189515_b(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager connection, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nonnull
    public NBTTagCompound getTileData() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean hasItem() {
        return !this.item.func_190926_b();
    }

    public boolean processClick() {
        if (this.lastClickTime + 1000L >= System.currentTimeMillis()) {
            return false;
        }
        this.lastClickTime = System.currentTimeMillis();
        if (this.tableResult != null) {
            ++this.clickCount;
            this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5, ((double)Wrapper.RANDOM.nextFloat() - 0.5) / 5.0, ((double)Wrapper.RANDOM.nextFloat() - 0.5) / 5.0, ((double)Wrapper.RANDOM.nextFloat() - 0.5) / 5.0, new int[]{Item.func_150891_b((Item)this.getItem().func_77973_b()), this.getItem().func_77952_i()});
            if (this.clickCount >= this.tableResult.getClickCount()) {
                if (!this.func_145831_w().field_72995_K) {
                    this.setItem(this.tableResult.getOutput().func_77946_l());
                    this.resetProcess();
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, 1.5f);
            } else {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 1.0f, 3.0f);
            }
            return true;
        }
        return false;
    }

    public CuttingTableRecipe getTableResult() {
        return this.tableResult;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    private void resetProcess() {
        this.tableResult = null;
        this.clickCount = 0;
    }

    public void setItem(ItemStack item) {
        if (item.func_190926_b()) {
            this.item = ItemStack.field_190927_a;
            this.resetProcess();
        } else {
            ItemStack is = item.func_77946_l();
            is.func_190920_e(1);
            this.item = is;
            this.tableResult = CuttingTableManager.getResult(is);
            this.clickCount = 0;
        }
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }
}

