/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.tile;

import cofh.redstoneflux.api.IEnergyReceiver;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedextraction.blocks.BlockAutoCuttingTable;
import ru.poopycoders.improvedextraction.custom.ModItems;
import ru.poopycoders.improvedextraction.custom.customrecipes.cuttingtable.CuttingTableManager;
import ru.poopycoders.improvedextraction.custom.customrecipes.cuttingtable.CuttingTableRecipe;

public class TileEntityAutoCuttingTable
extends TileEntity
implements ITickable,
ISidedInventory,
IEnergyReceiver {
    private static final int[] SLOTS_TOP = new int[]{0, 2};
    private static final int[] SLOTS_SIDES = new int[]{0, 2};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private static final int ENERGY_COST = 80;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int energy = 0;
    private int maxEnergyStored = 10000;
    private int canReceiveEnergy = 0;
    private CuttingTableRecipe result = null;
    private int maxCutTime = 0;
    private int cutTime = 0;
    private String customName;
    private boolean stateWorking;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy = tag.func_74762_e("Energy");
        this.cutTime = tag.func_74762_e("CutTime");
        this.maxCutTime = tag.func_74762_e("MaxCutTime");
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.items);
        this.result = CuttingTableManager.getResult((ItemStack)this.items.get(0));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("Energy", this.energy);
        tag.func_74768_a("CutTime", this.cutTime);
        tag.func_74768_a("MaxCutTime", this.maxCutTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.items);
        return super.func_189515_b(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager connection, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public NBTTagCompound getTileData() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean updateBlock = false;
            if (this.canWork() && this.energy >= 80) {
                if (!this.stateWorking) {
                    this.stateWorking = true;
                    BlockAutoCuttingTable.setState(true, this.field_145850_b, this.field_174879_c);
                    updateBlock = true;
                }
                ++this.cutTime;
                if (this.cutTime >= this.maxCutTime) {
                    this.cutOneItem();
                    this.cutTime = 0;
                }
                this.energy -= 80;
            } else if (this.stateWorking) {
                this.stateWorking = false;
                BlockAutoCuttingTable.setState(false, this.field_145850_b, this.field_174879_c);
                updateBlock = true;
            }
            if (updateBlock) {
                this.func_70296_d();
            }
            this.canReceiveEnergy = 160;
        }
    }

    private boolean canWork() {
        if (((ItemStack)this.items.get(0)).func_190926_b()) {
            return false;
        }
        if (this.result == null) {
            return false;
        }
        if (((ItemStack)this.items.get(2)).func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.items.get(1)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.items.get(1)).func_77969_a(this.result.getOutput())) {
            return false;
        }
        int resultCount = ((ItemStack)this.items.get(1)).func_190916_E() + this.result.getOutput().func_190916_E();
        return resultCount <= this.func_70297_j_() && resultCount <= ((ItemStack)this.items.get(1)).func_77976_d();
    }

    private void cutOneItem() {
        ((ItemStack)this.items.get(0)).func_190918_g(1);
        if (((ItemStack)this.items.get(1)).func_190926_b()) {
            this.items.set(1, (Object)this.result.getOutput().func_77946_l());
        } else {
            ((ItemStack)this.items.get(1)).func_190917_f(1);
        }
        if (((ItemStack)this.items.get(2)).func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
            this.items.set(2, (Object)ItemStack.field_190927_a);
        }
    }

    public CuttingTableRecipe getResult() {
        return this.result;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.field_145850_b.field_72995_K || !this.canConnectEnergy(from)) {
            return 0;
        }
        int canReceive = this.getMaxEnergyStored(from) - this.getEnergyStored(from);
        canReceive = MathHelper.func_76125_a((int)canReceive, (int)0, (int)this.canReceiveEnergy);
        if (!simulate) {
            this.energy += canReceive;
            this.canReceiveEnergy -= canReceive;
        }
        return canReceive;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.maxEnergyStored;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from.func_176740_k().func_176722_c();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.UP ? SLOTS_TOP : (side == EnumFacing.DOWN ? SLOTS_BOTTOM : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean sameItem = stack.func_77969_a((ItemStack)this.items.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.items.get(index)));
        this.items.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !sameItem) {
            this.result = CuttingTableManager.getResult(stack);
            this.cutTime = 0;
            this.maxCutTime = this.result == null ? 0 : this.result.getClickCount() * 20;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == ModItems.itemCuttingDisk ? index == 2 : index == 0;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.cutTime;
            }
            case 1: {
                return this.maxCutTime;
            }
            case 2: {
                return this.energy;
            }
            case 3: {
                return this.maxEnergyStored;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.cutTime = value;
                break;
            }
            case 1: {
                this.maxCutTime = value;
                break;
            }
            case 2: {
                this.energy = value;
                break;
            }
            case 3: {
                this.maxEnergyStored = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.auto_cutting_table";
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }
}

