/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.items;

import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import ru.poopycoders.improvedextraction.custom.customrecipes.stacker.StackerManager;
import ru.poopycoders.improvedextraction.custom.customrecipes.stacker.StackerRecipe;

public class ItemPortableStacker
extends Item {
    public ItemPortableStacker() {
        this.func_77656_e(2750);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nullable EnumHand hand) {
        NBTTagCompound nbt;
        ItemStack stacker = player.func_184586_b(hand);
        if (player.func_70093_af() && hand == EnumHand.MAIN_HAND && (nbt = stacker.func_77978_p()) != null && nbt.func_74764_b("StackerItemStacks")) {
            if (!world.field_72995_K) {
                NBTTagList tagList = nbt.func_150295_c("StackerItemStacks", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    ItemStack tempStack = new ItemStack(tagList.func_150305_b(i));
                    if (player.field_71071_by.func_70441_a(tempStack)) continue;
                    InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)tempStack);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, 1.0f);
                nbt.func_82580_o("StackerItemStacks");
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stacker);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stacker);
    }

    public static void processEvent(EntityItemPickupEvent event, ItemStack stacker) {
        StackerRecipe recipe = StackerManager.getRecipe(event.getItem().func_92059_d());
        if (recipe != null) {
            int i;
            NBTTagCompound compound = stacker.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
                stacker.func_77982_d(compound);
            }
            EntityPlayer player = event.getEntityPlayer();
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ItemStack picketUp = event.getItem().func_92059_d().func_77946_l();
            event.getItem().func_92059_d().func_190920_e(0);
            NBTTagList list = compound.func_150295_c("StackerItemStacks", 10);
            NBTTagList newList = new NBTTagList();
            LinkedList<ItemStack> similarStacks = new LinkedList<ItemStack>();
            int count = picketUp.func_190916_E();
            for (int i2 = 0; i2 < list.func_74745_c(); ++i2) {
                NBTTagCompound stackCompound = list.func_150305_b(i2);
                ItemStack stack = new ItemStack(stackCompound);
                if (stack.func_77973_b() != picketUp.func_77973_b() || stack.func_77952_i() != picketUp.func_77952_i()) {
                    newList.func_74742_a((NBTBase)stackCompound);
                    continue;
                }
                similarStacks.add(stack);
                count += stack.func_190916_E();
            }
            boolean b = true;
            for (ItemStack similarStack : similarStacks) {
                if (similarStack.func_77973_b() != picketUp.func_77973_b() || similarStack.func_77952_i() != picketUp.func_77952_i() || !ItemStack.func_77970_a((ItemStack)picketUp, (ItemStack)similarStack)) continue;
                similarStack.func_190917_f(picketUp.func_190916_E());
                b = false;
                break;
            }
            if (b) {
                similarStacks.add(picketUp);
            }
            int compressCount = Math.min(count / recipe.getInputCount(), stacker.func_77958_k() - stacker.func_77952_i());
            int removedCount = compressCount * recipe.getInputCount();
            for (ItemStack similarStack : similarStacks) {
                if (similarStack.func_190916_E() <= removedCount) {
                    removedCount -= similarStack.func_190916_E();
                    similarStack.func_190920_e(0);
                } else {
                    similarStack.func_190918_g(removedCount);
                    removedCount = 0;
                }
                if (similarStack.func_190916_E() <= 0) continue;
                newList.func_74742_a((NBTBase)similarStack.func_77955_b(new NBTTagCompound()));
            }
            for (i = 0; i < compressCount; ++i) {
                ItemStack is = recipe.getOutput().func_77946_l();
                if (player.field_71071_by.func_70441_a(is)) continue;
                InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)is);
            }
            stacker.func_96631_a(compressCount, player.func_70681_au(), player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null);
            if (stacker.func_77952_i() >= stacker.func_77958_k()) {
                for (i = 0; i < newList.func_74745_c(); ++i) {
                    NBTTagCompound stackCompound = newList.func_150305_b(i);
                    ItemStack is = new ItemStack(stackCompound);
                    InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)is);
                }
                player.field_71071_by.func_184437_d(stacker);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            } else {
                compound.func_74782_a("StackerItemStacks", (NBTBase)newList);
            }
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

