/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.integrations.jei.categories;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedextraction.custom.ModBlocks;
import ru.poopycoders.improvedextraction.custom.customrecipes.IRecipe;
import ru.poopycoders.improvedextraction.custom.customrecipes.cuttingtable.CuttingTableManager;
import ru.poopycoders.improvedextraction.gui.GuiAutoCuttingTable;
import ru.poopycoders.improvedextraction.gui.containers.ContainerAutoCuttingTable;
import ru.poopycoders.improvedextraction.integrations.jei.recipes.CuttingTableBlankRecipe;
import ru.poopycoders.improvedextraction.integrations.jei.recipes.RecipeHandler;

@SideOnly(value=Side.CLIENT)
public class CuttingTableCategory
extends BlankRecipeCategory<CuttingTableBlankRecipe> {
    public static final String UID = "AutoCuttingTable";
    private int xOff = 30;
    private int yOff = 17;
    private final IDrawable background;
    protected final IDrawableAnimated flame;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CuttingTableCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new RecipeHandler<CuttingTableBlankRecipe>(CuttingTableBlankRecipe.class, UID)});
        registry.addRecipeClickArea(GuiAutoCuttingTable.class, 79, 38, 25, 9, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ModBlocks.autoCuttingTable), new String[]{UID});
        ArrayList<CuttingTableBlankRecipe> result = new ArrayList<CuttingTableBlankRecipe>();
        for (IRecipe iRecipe : CuttingTableManager.getRecipes().values()) {
            result.add(new CuttingTableBlankRecipe(iRecipe));
        }
        registry.addRecipes(result);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAutoCuttingTable.class, UID, ContainerAutoCuttingTable.FIRST_RECIPE_SLOT, ContainerAutoCuttingTable.NUM_RECIPE_SLOT, ContainerAutoCuttingTable.FIRST_INVENTORY_SLOT, ContainerAutoCuttingTable.NUM_INVENTORY_SLOT);
    }

    public CuttingTableCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = GuiAutoCuttingTable.BACKGROUND_TEXTURE;
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 139, 66);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 0, 23, 7);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        String localizedName = ModBlocks.autoCuttingTable.func_149732_F();
        return localizedName != null ? localizedName : "ERROR";
    }

    public String getModName() {
        return "Improved Extraction";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 80 - this.xOff, 39 - this.yOff);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CuttingTableBlankRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 54 - this.xOff, 34 - this.yOff);
        guiItemStacks.init(1, false, 115 - this.xOff, 34 - this.yOff);
        guiItemStacks.init(2, true, 33 - this.xOff, 34 - this.yOff);
        List inputs = ingredients.getInputs(ItemStack.class);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(2, (List)inputs.get(1));
        List outputs = ingredients.getOutputs(ItemStack.class);
        guiItemStacks.set(1, (List)outputs.get(0));
    }
}

