/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.integrations.jei;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedextraction.custom.ModItems;
import ru.poopycoders.improvedextraction.custom.resources.CrystalType;
import ru.poopycoders.improvedextraction.custom.resources.MetalType;
import ru.poopycoders.improvedextraction.custom.resources.RockType;
import ru.poopycoders.improvedextraction.custom.resources.interfaces.IResourceType;
import ru.poopycoders.improvedextraction.integrations.jei.ItemDescription;
import ru.poopycoders.improvedextraction.utils.Utils;

@SideOnly(value=Side.CLIENT)
public class JEIManager {
    private static ArrayList<ItemDescription> itemDescriptions = new ArrayList();

    public static void register() {
        JEIManager.addItemDescription(ModItems.itemRock, RockType.values());
        JEIManager.addItemDescription(ModItems.itemOreFragment, MetalType.values());
        JEIManager.addItemDescription(ModItems.itemOreCluster, MetalType.values());
        JEIManager.addItemDescription(ModItems.itemRawCrystal, CrystalType.values());
    }

    public static void addItemDescription(ItemStack stack, String ... descs) {
        itemDescriptions.add(new ItemDescription(stack, descs));
    }

    public static void addItemDescription(ItemStack stack) {
        JEIManager.addItemDescription(stack, Utils.getTranslateText("jei.description." + stack.func_77973_b().getRegistryName().func_110623_a()).split("\n"));
    }

    public static void addItemDescription(Item item, IResourceType[] types) {
        for (IResourceType type : types) {
            JEIManager.addItemDescription(new ItemStack(item, 1, type.getMeta()));
        }
    }

    public static ArrayList<ItemDescription> getItemDescriptions() {
        return itemDescriptions;
    }
}

