/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom.resources;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import ru.poopycoders.improvedextraction.custom.ModBlocks;
import ru.poopycoders.improvedextraction.custom.drop.CustomDrop;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IdItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.ItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.OreDictionaryItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.types.ChanceDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.Drop;
import ru.poopycoders.improvedextraction.custom.drop.types.GroupDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.SilkTouchDrop;
import ru.poopycoders.improvedextraction.custom.resources.interfaces.IResourceType;

public enum RockType implements IResourceType
{
    STONE(0, "stone", DropType.COBBLESTONE, (IItemContainer)new OreDictionaryItemContainer("cobblestone"), new IItemContainer[]{new OreDictionaryItemContainer("stone")}){

        @Override
        public void initCustomDrop(ItemBlock itemBlock, CustomDrop customDrop) {
            customDrop.addDrop(new SilkTouchDrop(null, new ChanceDrop(new GroupDrop().addItem(new Drop(new ItemStack(Items.field_151103_aS), 1), 10).addItem(new Drop(new ItemStack(Items.field_151144_bL), 1), 1), 0.005f)));
        }
    }
    ,
    GRANITE(1, "granite", DropType.STONE, (IItemContainer)new OreDictionaryItemContainer("cobblestoneGranite"), new OreDictionaryItemContainer("stoneGranite")),
    DIORITE(2, "diorite", DropType.STONE, (IItemContainer)new OreDictionaryItemContainer("cobblestoneDiorite"), new OreDictionaryItemContainer("stoneDiorite")),
    ANDESITE(3, "andesite", DropType.STONE, (IItemContainer)new OreDictionaryItemContainer("cobblestoneAndesite"), new OreDictionaryItemContainer("stoneAndesite")),
    NETHER(4, "nether", -7657432, DropType.STONE, (IItemContainer)new ItemContainer(ModBlocks.customCobblestone, 3), new OreDictionaryItemContainer("netherrack")),
    END(5, "end", -1712473, DropType.STONE, (IItemContainer)new ItemContainer(ModBlocks.customCobblestone, 4), new ItemContainer(Blocks.field_150377_bs)),
    BASALT(6, "basalt", DropType.STONE, (IItemContainer)new OreDictionaryItemContainer("cobblestoneBasalt"), new OreDictionaryItemContainer("stoneBasalt")),
    SOULSTONE(7, "soulstone", DropType.COBBLESTONE, (IItemContainer)new IdItemContainer("mysticalagriculture:soulstone", 1), new IdItemContainer("mysticalagriculture:soulstone", 0)),
    MARBLE(8, "marble", DropType.STONE, (IItemContainer)new OreDictionaryItemContainer("cobblestoneMarble"), new OreDictionaryItemContainer("stoneMarble"), new OreDictionaryItemContainer("stoneMarmor")),
    LIMESTONE(9, "limestone", DropType.STONE, (IItemContainer)new OreDictionaryItemContainer("cobblestoneLimestone"), new OreDictionaryItemContainer("stoneLimestone"));

    private final int meta;
    private final String name;
    private int color;
    private DropType dropType;
    private IItemContainer cobblestoneContainer;
    private IItemContainer[] stoneContainers;
    private boolean enabled = true;

    private RockType(int meta, String name, int color, DropType dropType, IItemContainer cobblestoneContainer, IItemContainer ... stoneContainers) {
        this.meta = meta;
        this.name = name;
        this.color = color;
        this.dropType = dropType;
        this.cobblestoneContainer = cobblestoneContainer;
        this.stoneContainers = stoneContainers;
    }

    private RockType(int meta, String name, DropType dropType, IItemContainer cobblestoneContainer, IItemContainer ... stoneContainers) {
        this(meta, name, -8947849, dropType, cobblestoneContainer, stoneContainers);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DropType getDropType() {
        return this.dropType;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static RockType byMeta(int meta) {
        if (meta < 0 || meta >= RockType.values().length) {
            meta = 0;
        }
        return RockType.values()[meta];
    }

    public IItemContainer getCobblestoneContainer() {
        return this.cobblestoneContainer;
    }

    public IItemContainer[] getStoneContainers() {
        return this.stoneContainers;
    }

    public void initCustomDrop(ItemBlock itemBlock, CustomDrop customDrop) {
    }

    public int getColor() {
        return this.color;
    }

    public static enum DropType {
        STONE,
        COBBLESTONE;

    }
}

