/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom.resources;

import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import ru.poopycoders.improvedextraction.Wrapper;
import ru.poopycoders.improvedextraction.custom.ModItems;
import ru.poopycoders.improvedextraction.custom.drop.CustomDrop;
import ru.poopycoders.improvedextraction.custom.drop.CustomDropManager;
import ru.poopycoders.improvedextraction.custom.drop.ItemData;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.Containers;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IdItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.OreDictionaryItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.orecontainers.MetalOreContainer;
import ru.poopycoders.improvedextraction.custom.drop.types.Drop;
import ru.poopycoders.improvedextraction.custom.drop.types.FortuneDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.RemovingDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.SilkTouchDrop;
import ru.poopycoders.improvedextraction.custom.resources.RockType;
import ru.poopycoders.improvedextraction.custom.resources.interfaces.IExtractableType;
import ru.poopycoders.improvedextraction.utils.Aliases;
import ru.poopycoders.improvedextraction.utils.StateInfo;

public enum MetalType implements IExtractableType
{
    IRON(0, "iron", new Aliases("magnetite"), "ingotIron", new MetalOreContainer[0]),
    GOLD(1, "gold", "ingotGold", new MetalOreContainer[0]),
    COPPER(2, "copper", new Aliases("cuprite"), "ingotCopper", new MetalOreContainer[0]),
    TIN(3, "tin", new Aliases("cassiterite"), "ingotTin", new MetalOreContainer[0]),
    SILVER(4, "silver", new Aliases("electrum"), "ingotSilver", new MetalOreContainer[0]),
    LEAD(5, "lead", "ingotLead", new MetalOreContainer[0]),
    ALUMINIUM(6, "aluminium", new Aliases("aluminum", "bauxite"), new Containers(new OreDictionaryItemContainer("ingotAluminium"), new OreDictionaryItemContainer("ingotAluminum")), new MetalOreContainer[0]),
    NICKEL(7, "nickel", "ingotNickel", new MetalOreContainer[0]),
    FINITE(8, "finite", "ingotFinite", new MetalOreContainer(RockType.END, new IdItemContainer("improvedextraction:finite_ore", 0))),
    CHROME(9, "chrome", "ingotChrome", new MetalOreContainer[0]),
    PLATINUM(10, "platinum", "ingotPlatinum", new MetalOreContainer[0]),
    ZINC(11, "zinc", "ingotZinc", new MetalOreContainer[0]),
    GALENA(12, "galena", "ingotGalena", new MetalOreContainer[0]),
    IRIDIUM(13, "iridium", "ingotIridium", new MetalOreContainer[0]),
    TITANIUM(14, "titanium", new Aliases("rutile"), "ingotTitanium", new MetalOreContainer[0]),
    URANIUM(15, "uranium", new Aliases("yellorite", "yellorium"), "ingotUranium", new MetalOreContainer[0]);

    private final int meta;
    private final String name;
    private Aliases aliases;
    MetalOreContainer[] oreContainers;
    Containers ingotContainers;
    private boolean enabled = true;

    private MetalType(int meta, String name, Aliases aliases, Containers ingotContainer, MetalOreContainer ... oreContainers) {
        this.meta = meta;
        this.name = name;
        this.aliases = aliases;
        this.aliases.add(name);
        this.oreContainers = oreContainers;
        this.ingotContainers = ingotContainer;
    }

    private MetalType(int meta, String name, Containers ingotContainer, MetalOreContainer ... oreContainers) {
        this(meta, name, new Aliases(), ingotContainer, oreContainers);
    }

    private MetalType(int meta, String name, Aliases aliases, String ingotDictionaryName, MetalOreContainer ... oreContainers) {
        this(meta, name, aliases, new Containers(new OreDictionaryItemContainer(ingotDictionaryName)), oreContainers);
    }

    private MetalType(int meta, String name, String ingotDictionaryName, MetalOreContainer ... oreContainers) {
        this(meta, name, new Aliases(), new Containers(new OreDictionaryItemContainer(ingotDictionaryName)), oreContainers);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Containers getIngotContainers() {
        return this.ingotContainers;
    }

    public MetalOreContainer[] getOreContainers() {
        return this.oreContainers;
    }

    public static MetalType byMeta(int meta) {
        if (meta < 0 || meta >= MetalType.values().length) {
            meta = 0;
        }
        return MetalType.values()[meta];
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    public void registerCustomDrop(Block block, int blockMeta, RockType rockType, int[] rocksCount, int[] fragmentsCount) {
        if (!this.isEnabled()) {
            return;
        }
        CustomDrop customDrop = new CustomDrop(block, blockMeta);
        ItemStack fragment = new ItemStack((Item)ModItems.itemOreFragment, 1, this.meta);
        byte type = (byte)rockType.getMeta();
        if (type != 0) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("RockType", type);
            fragment.func_77982_d(compound);
        }
        Item defaultItem = block.func_180660_a(block.func_176223_P(), Wrapper.RANDOM, 0);
        int defaultMeta = block.func_180651_a(block.func_176223_P());
        ItemStack silkTouchDrop = null;
        for (IItemContainer itemContainer : rockType.getStoneContainers()) {
            ItemStack stack;
            Iterator<ItemStack> iterator = itemContainer.getItems().iterator();
            if (!iterator.hasNext()) continue;
            silkTouchDrop = stack = iterator.next();
        }
        customDrop.addDrop(new SilkTouchDrop(new Drop(silkTouchDrop), new Drop(new ItemStack((Item)ModItems.itemRock, 1, rockType.getMeta()), rocksCount)));
        customDrop.addDrop(new FortuneDrop(fragment, 1, 9, fragmentsCount));
        customDrop.addDrop(new RemovingDrop(ItemData.byItem(new ItemStack(defaultItem, 1, defaultMeta))));
        if (defaultItem != Item.func_150898_a((Block)block) || defaultMeta != blockMeta) {
            customDrop.addDrop(new RemovingDrop(ItemData.byItem(new ItemStack(block, 1, blockMeta))));
        }
        CustomDropManager.registerDrop(customDrop);
    }

    @Override
    public void registerCustomDrop(StateInfo stateInfo, RockType rockType) {
        int[] fragmentsCount = Wrapper.ORE_FRAGMENTS_COUNT;
        if (rockType == RockType.NETHER) {
            fragmentsCount = Wrapper.NETHER_ORE_FRAGMENTS_COUNT;
        } else if (rockType == RockType.END) {
            fragmentsCount = Wrapper.END_ORE_FRAGMENTS_COUNT;
        } else if (stateInfo.is("double")) {
            fragmentsCount = Wrapper.DOUBLE_ORE_FRAGMENTS_COUNT;
        } else if (stateInfo.is("compressed")) {
            fragmentsCount = Wrapper.COMPRESSED_ORE_FRAGMENTS_COUNT;
        }
        this.registerCustomDrop(stateInfo.getState().func_177230_c(), stateInfo.getMeta(), rockType, Wrapper.ROCKS_COUNT, fragmentsCount);
    }
}

