/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom.resources;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ru.poopycoders.improvedextraction.Wrapper;
import ru.poopycoders.improvedextraction.custom.ModItems;
import ru.poopycoders.improvedextraction.custom.drop.CustomDrop;
import ru.poopycoders.improvedextraction.custom.drop.CustomDropManager;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IdItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.ItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.orecontainers.OreContainer;
import ru.poopycoders.improvedextraction.custom.drop.types.Drop;
import ru.poopycoders.improvedextraction.custom.drop.types.SilkTouchDrop;
import ru.poopycoders.improvedextraction.custom.resources.RockType;
import ru.poopycoders.improvedextraction.custom.resources.interfaces.IExtractableType;
import ru.poopycoders.improvedextraction.utils.StateInfo;

public enum GemType implements IExtractableType
{
    COAL(0, "coal", new OreContainer[0]),
    REDSTONE(1, "redstone", new OreContainer[0]),
    LAPIS(2, "lapis", new OreContainer[0]),
    QUARTZ(3, "quartz", new OreContainer(RockType.NETHER, new ItemContainer(Blocks.field_150449_bY))),
    BIOTITE(4, "biotite", new OreContainer(RockType.END, new IdItemContainer("quark:biotite_ore", 0))),
    INFERIUM(5, "inferium", new OreContainer[0]),
    PROSPERITY(6, "prosperity", new OreContainer[0]);

    private final int meta;
    private final String name;
    OreContainer[] oreContainers;
    private boolean enabled = true;

    private GemType(int meta, String name, OreContainer ... oreContainers) {
        this.meta = meta;
        this.name = name;
        this.oreContainers = oreContainers;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public OreContainer[] getOreContainers() {
        return this.oreContainers;
    }

    public static GemType byMeta(int meta) {
        if (meta < 0 || meta >= GemType.values().length) {
            meta = 0;
        }
        return GemType.values()[meta];
    }

    public void registerCustomDrop(Block block, int blockMeta, RockType rockType, int[] rocksCount) {
        if (!this.isEnabled()) {
            return;
        }
        CustomDrop customDrop = new CustomDrop(block, blockMeta);
        customDrop.addDrop(new SilkTouchDrop(null, new Drop(new ItemStack((Item)ModItems.itemRock, 1, rockType.getMeta()), rocksCount)));
        CustomDropManager.registerDrop(customDrop);
    }

    @Override
    public void registerCustomDrop(StateInfo stateInfo, RockType rockType) {
        this.registerCustomDrop(stateInfo.getState().func_177230_c(), stateInfo.getMeta(), rockType, Wrapper.ROCKS_COUNT);
    }
}

