/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom.resources;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ru.poopycoders.improvedextraction.Wrapper;
import ru.poopycoders.improvedextraction.custom.ModItems;
import ru.poopycoders.improvedextraction.custom.drop.CustomDrop;
import ru.poopycoders.improvedextraction.custom.drop.CustomDropManager;
import ru.poopycoders.improvedextraction.custom.drop.ItemData;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.Containers;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IdItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.OreDictionaryItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.orecontainers.OreContainer;
import ru.poopycoders.improvedextraction.custom.drop.types.Drop;
import ru.poopycoders.improvedextraction.custom.drop.types.DropsList;
import ru.poopycoders.improvedextraction.custom.drop.types.ReplacingDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.SilkTouchDrop;
import ru.poopycoders.improvedextraction.custom.resources.RockType;
import ru.poopycoders.improvedextraction.custom.resources.interfaces.IExtractableType;
import ru.poopycoders.improvedextraction.utils.Aliases;
import ru.poopycoders.improvedextraction.utils.StateInfo;

public enum CrystalType implements IExtractableType
{
    DIAMOND(0, "diamond", -11478851, new Containers(new OreDictionaryItemContainer("gemDiamond")), 4.0f, 17, new OreContainer[0]),
    EMERALD(1, "emerald", -13641681, new Containers(new OreDictionaryItemContainer("gemEmerald")), 5.0f, 12, new OreContainer[0]),
    RUBY(2, "ruby", -3400667, new Containers(new OreDictionaryItemContainer("gemRuby"), new IdItemContainer("newthings:ruby", 0)), 5.0f, 14, new OreContainer[0]),
    SAPPHIRE(3, "sapphire", -12294442, new Containers(new OreDictionaryItemContainer("gemSapphire")), 2.0f, 12, new OreContainer[0]),
    MALACHITE(4, "malachite", -11150445, new Containers(new OreDictionaryItemContainer("gemMalachite")), 2.0f, 8, new OreContainer[0]),
    TOPAZ(5, "topaz", -1944296, new Containers(new OreDictionaryItemContainer("gemTopaz")), 3.0f, 11, new OreContainer[0]),
    AMETHYST(6, "amethyst", -9552954, new Containers(new OreDictionaryItemContainer("gemAmethyst")), 3.0f, 13, new OreContainer[0]),
    AQUAMARINE(7, "aquamarine", -16721718, new Containers(new OreDictionaryItemContainer("gemAquamarine")), 3.0f, 7, new OreContainer[0]),
    AMBER(8, "amber", -2057421, new Containers(new OreDictionaryItemContainer("gemAmber")), 3.0f, 7, new OreContainer[0]),
    MOONSTONE(9, "moonstone", -5383208, new Containers(new OreDictionaryItemContainer("gemMoonstone")), 3.0f, 18, new OreContainer[0]);

    private final int meta;
    private final String name;
    private int color;
    private OreContainer[] oreContainers;
    private Aliases aliases;
    private Containers gemContainers;
    private float cuttingXp;
    private int cuttingClickCount;
    private boolean enabled = true;

    private CrystalType(int meta, String name, int color, Aliases aliases, Containers gemContainers, float cuttingXp, int cuttingClickCount, OreContainer ... oreContainers) {
        this.meta = meta;
        this.name = name;
        this.color = color;
        this.oreContainers = oreContainers;
        this.aliases = aliases;
        this.aliases.add(name);
        this.gemContainers = gemContainers;
        this.cuttingXp = cuttingXp;
        this.cuttingClickCount = cuttingClickCount;
    }

    private CrystalType(int meta, String name, int color, Containers gemContainers, float cuttingXp, int cuttingClickCount, OreContainer ... oreContainers) {
        this(meta, name, color, new Aliases(), gemContainers, cuttingXp, cuttingClickCount, oreContainers);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    public OreContainer[] getOreContainers() {
        return this.oreContainers;
    }

    public int getCuttingClickCount() {
        return this.cuttingClickCount;
    }

    public float getCuttingXp() {
        return this.cuttingXp;
    }

    public Containers getGemContainers() {
        return this.gemContainers;
    }

    public static CrystalType byMeta(int meta) {
        if (meta < 0 || meta >= CrystalType.values().length) {
            meta = 0;
        }
        return CrystalType.values()[meta];
    }

    public void registerCustomDrop(Block block, int blockMeta, RockType rockType, int[] rocksCount) {
        if (!this.isEnabled()) {
            return;
        }
        CustomDrop customDrop = new CustomDrop(block, blockMeta);
        DropsList dropsList = new DropsList();
        dropsList.add(new Drop(new ItemStack((Item)ModItems.itemRock, 1, rockType.getMeta()), rocksCount));
        for (IItemContainer gemContainer : this.gemContainers.getContainers()) {
            for (ItemStack gem : gemContainer.getItems()) {
                if (gem.func_77973_b() == null) continue;
                dropsList.add(new ReplacingDrop(ItemData.byItem(gem), new Drop(new ItemStack((Item)ModItems.itemRawCrystal, 1, this.meta), 1)));
            }
        }
        customDrop.addDrop(new SilkTouchDrop(null, dropsList));
        CustomDropManager.registerDrop(customDrop);
    }

    @Override
    public void registerCustomDrop(StateInfo stateInfo, RockType rockType) {
        this.registerCustomDrop(stateInfo.getState().func_177230_c(), stateInfo.getMeta(), rockType, Wrapper.ROCKS_COUNT);
    }
}

