/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom.drop.types;

import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import ru.poopycoders.improvedextraction.Wrapper;
import ru.poopycoders.improvedextraction.custom.drop.types.IDrop;
import ru.poopycoders.improvedextraction.utils.Counter;

public class FortuneDrop
implements IDrop {
    private ItemStack stack;
    private int[] count;
    private int perLevel;
    private int maxCount;

    public FortuneDrop(ItemStack stack, int perLevel, int maxCount, int ... count) {
        this.stack = stack;
        this.count = count;
        this.perLevel = perLevel;
        this.maxCount = maxCount;
    }

    public FortuneDrop(ItemStack stack, int perLevel, int maxCount) {
        this(stack, perLevel, maxCount, 1);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getPerLevel() {
        return this.perLevel;
    }

    public int[] getCount() {
        return this.count;
    }

    public int getRandomCount() {
        return this.count[Wrapper.RANDOM.nextInt(this.count.length)];
    }

    public ItemStack getNewItem(int fortune) {
        ItemStack newStack = this.stack.func_77946_l();
        int c = Math.min(this.maxCount, this.getRandomCount() + Wrapper.RANDOM.nextInt(fortune + 1));
        newStack.func_190920_e(c);
        return newStack;
    }

    @Override
    public void apply(BlockEvent.HarvestDropsEvent event, Counter dropCounter) {
        event.getDrops().add(this.getNewItem(event.getFortuneLevel()));
        dropCounter.add();
    }
}

