/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom.drop;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.GameData;
import ru.poopycoders.improvedextraction.Wrapper;
import ru.poopycoders.improvedextraction.blocks.BlockCustomCobblestone;
import ru.poopycoders.improvedextraction.config.ModConfig;
import ru.poopycoders.improvedextraction.custom.ModItems;
import ru.poopycoders.improvedextraction.custom.drop.CustomDrop;
import ru.poopycoders.improvedextraction.custom.drop.ItemData;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.orecontainers.MetalOreContainer;
import ru.poopycoders.improvedextraction.custom.drop.orecontainers.OreContainer;
import ru.poopycoders.improvedextraction.custom.drop.types.ChanceDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.Drop;
import ru.poopycoders.improvedextraction.custom.drop.types.DropsArray;
import ru.poopycoders.improvedextraction.custom.drop.types.DropsList;
import ru.poopycoders.improvedextraction.custom.drop.types.GroupDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.RemovingDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.ReplacingDrop;
import ru.poopycoders.improvedextraction.custom.drop.types.SilkTouchDrop;
import ru.poopycoders.improvedextraction.custom.resources.CrystalType;
import ru.poopycoders.improvedextraction.custom.resources.GemType;
import ru.poopycoders.improvedextraction.custom.resources.MetalType;
import ru.poopycoders.improvedextraction.custom.resources.RockType;
import ru.poopycoders.improvedextraction.utils.StateInfo;

public class CustomDropManager {
    private static LinkedList<CustomDrop> customDrops = new LinkedList();

    public static void registerDrop(CustomDrop customDrop) {
        if (ModConfig.black_list.contains(customDrop.getBlock().getRegistryName() + ":" + String.valueOf(customDrop.getBlockMeta())) || ModConfig.black_list.contains(customDrop.getBlock().getRegistryName() + ":-1")) {
            return;
        }
        Iterator iter = customDrops.iterator();
        while (iter.hasNext()) {
            CustomDrop cd = (CustomDrop)iter.next();
            if (customDrop.getBlock() != cd.getBlock() || customDrop.getBlockMeta() != cd.getBlockMeta()) continue;
            iter.remove();
        }
        customDrops.add(customDrop);
    }

    public static void register() {
        Block block;
        Block[] dirtBlocks;
        CustomDrop customDrop;
        block0: for (Object state : GameData.getBlockStateIDMap()) {
            StateInfo stateInfo = new StateInfo((IBlockState)state);
            if (!stateInfo.is("ore")) continue;
            RockType rockType = RockType.STONE;
            if (stateInfo.is("nether")) {
                rockType = RockType.NETHER;
            } else if (stateInfo.is("end")) {
                rockType = RockType.END;
            }
            boolean find = false;
            block1: for (MetalType metalType : MetalType.values()) {
                if (find) break;
                for (String alias : metalType.getAliases().get()) {
                    if (!stateInfo.is(alias)) continue;
                    metalType.registerCustomDrop(stateInfo, rockType);
                    find = true;
                    continue block1;
                }
            }
            for (CrystalType crystalType : CrystalType.values()) {
                if (!stateInfo.is(crystalType.func_176610_l())) continue;
                crystalType.registerCustomDrop(stateInfo, rockType);
                break;
            }
            for (GemType gemType : GemType.values()) {
                if (!stateInfo.is(gemType.func_176610_l())) continue;
                gemType.registerCustomDrop(stateInfo, rockType);
                continue block0;
            }
        }
        for (IBlockState type : RockType.values()) {
            if (!type.isEnabled()) continue;
            for (IItemContainer stoneContainer : type.getStoneContainers()) {
                for (ItemStack itemStack : stoneContainer.getItems()) {
                    if (!(itemStack.func_77973_b() instanceof ItemBlock)) continue;
                    ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
                    customDrop = new CustomDrop(itemBlock.func_179223_d(), itemStack.func_77952_i());
                    DropsList dropsList = new DropsList();
                    if (type.getDropType() == RockType.DropType.COBBLESTONE) {
                        for (ItemStack cobblestone : type.getCobblestoneContainer().getItems()) {
                            if (!(cobblestone.func_77973_b() instanceof ItemBlock)) continue;
                            dropsList.add(new RemovingDrop(new ItemData(((ItemBlock)cobblestone.func_77973_b()).func_179223_d(), cobblestone.func_77952_i())));
                        }
                    } else {
                        dropsList.add(new RemovingDrop(new ItemData(itemBlock.func_179223_d(), itemStack.func_77952_i())));
                    }
                    dropsList.add(new Drop(new ItemStack((Item)ModItems.itemRock, 1, type.getMeta()), 1, 1, 2, 2, 3));
                    customDrop.addDrop(new SilkTouchDrop(null, dropsList));
                    type.initCustomDrop(itemBlock, customDrop);
                    CustomDropManager.registerDrop(customDrop);
                }
            }
            for (ItemStack cobblestone : type.getCobblestoneContainer().getItems()) {
                if (!(cobblestone.func_77973_b() instanceof ItemBlock)) continue;
                Block block2 = ((ItemBlock)cobblestone.func_77973_b()).func_179223_d();
                customDrop = new CustomDrop(block2, cobblestone.func_77952_i());
                customDrop.addDrop(new SilkTouchDrop(null, new ReplacingDrop(new ItemData(block2, cobblestone.func_77952_i()), new Drop(new ItemStack((Item)ModItems.itemRock, 1, type.getMeta()), BlockCustomCobblestone.randomCount))));
                CustomDropManager.registerDrop(customDrop);
            }
        }
        customDrop = new CustomDrop(Blocks.field_150341_Y);
        customDrop.addDrop(new SilkTouchDrop(null, new DropsArray(new Drop(new ItemStack((Item)ModItems.itemRock), BlockCustomCobblestone.randomCount), new ChanceDrop(new Drop(new ItemStack(Blocks.field_150395_bd), 1), 0.5f), new RemovingDrop(new ItemData(Blocks.field_150341_Y)))));
        CustomDropManager.registerDrop(customDrop);
        for (ItemStack itemStack : OreDictionary.getOres((String)"blockMossy")) {
            if (!(itemStack.func_77973_b() instanceof ItemBlock)) continue;
            Block block3 = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
            customDrop = new CustomDrop(block3, itemStack.func_77952_i());
            customDrop.addDrop(new SilkTouchDrop(null, new DropsArray(new Drop(new ItemStack((Item)ModItems.itemRock), BlockCustomCobblestone.randomCount), new ChanceDrop(new Drop(new ItemStack(Blocks.field_150395_bd), 1), 0.5f), new RemovingDrop(ItemData.byItem(itemStack)))));
            CustomDropManager.registerDrop(customDrop);
        }
        customDrop = new CustomDrop(Blocks.field_150351_n);
        customDrop.addDrop(new SilkTouchDrop(null, new ReplacingDrop(new ItemData(Blocks.field_150351_n), new Drop(new ItemStack((Item)ModItems.itemSmallRock), 3, 4, 4, 5, 6))));
        CustomDropManager.registerDrop(customDrop);
        customDrop = new CustomDrop((Block)Blocks.field_150354_m);
        customDrop.addDrop(new SilkTouchDrop(null, new ChanceDrop(new ReplacingDrop(new ItemData((Block)Blocks.field_150354_m), new Drop(new ItemStack((Item)ModItems.itemFishSkeleton))), 0.005f)));
        CustomDropManager.registerDrop(customDrop);
        for (Block block2 : dirtBlocks = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_185774_da, Blocks.field_150391_bh, Blocks.field_150458_ak}) {
            customDrop = new CustomDrop(block2){

                @Override
                public boolean isSuitable(BlockEvent.HarvestDropsEvent event) {
                    return Wrapper.RANDOM.nextInt(100) < 20;
                }
            };
            customDrop.addDrop(new SilkTouchDrop(null, new ChanceDrop(new DropsArray(new GroupDrop().addItem(new Drop(new ItemStack((Item)ModItems.itemSmallRock)), 4).addItem(new Drop(new ItemStack((Item)ModItems.itemRock)), 4).addItem(new Drop(new ItemStack((Item)ModItems.itemRock, 1, 1)), 1).addItem(new Drop(new ItemStack((Item)ModItems.itemRock, 1, 2)), 1).addItem(new Drop(new ItemStack((Item)ModItems.itemRock, 1, 3)), 1), new RemovingDrop(new ItemData(block2)), new RemovingDrop(new ItemData(Blocks.field_150346_d))), 0.2f)));
            CustomDropManager.registerDrop(customDrop);
        }
        for (MetalType metalType : MetalType.values()) {
            for (MetalOreContainer metalOreContainer : metalType.getOreContainers()) {
                for (ItemStack item : metalOreContainer.getItemContainer().getItems()) {
                    if (!(item.func_77973_b() instanceof ItemBlock)) continue;
                    block = ((ItemBlock)item.func_77973_b()).func_179223_d();
                    metalType.registerCustomDrop(block, item.func_77952_i(), metalOreContainer.getRockType(block), metalOreContainer.getRockCounts(), metalOreContainer.getFragmentsCount());
                }
            }
        }
        for (CrystalType crystalType : CrystalType.values()) {
            for (OreContainer oreContainer : crystalType.getOreContainers()) {
                for (ItemStack item : oreContainer.getItemContainer().getItems()) {
                    if (!(item.func_77973_b() instanceof ItemBlock)) continue;
                    block = ((ItemBlock)item.func_77973_b()).func_179223_d();
                    crystalType.registerCustomDrop(block, item.func_77952_i(), oreContainer.getRockType(block), oreContainer.getRockCounts());
                }
            }
        }
        for (GemType gemType : GemType.values()) {
            for (OreContainer oreContainer : gemType.getOreContainers()) {
                for (ItemStack item : oreContainer.getItemContainer().getItems()) {
                    if (!(item.func_77973_b() instanceof ItemBlock)) continue;
                    block = ((ItemBlock)item.func_77973_b()).func_179223_d();
                    gemType.registerCustomDrop(block, item.func_77952_i(), oreContainer.getRockType(block), oreContainer.getRockCounts());
                }
            }
        }
    }

    public static CustomDrop getCustomDrop(BlockEvent.HarvestDropsEvent event) {
        for (CustomDrop customDrop : customDrops) {
            if (customDrop.getBlock() != event.getState().func_177230_c() || customDrop.getBlockMeta() != -1 && customDrop.getBlockMeta() != event.getState().func_177230_c().func_176201_c(event.getState()) || !customDrop.isSuitable(event)) continue;
            return customDrop;
        }
        return null;
    }

    private static boolean isContainsDrop(List<ItemStack> list, ItemStack item) {
        for (ItemStack stack : list) {
            if (stack.func_77973_b() != item.func_77973_b() || stack.func_77952_i() != item.func_77952_i()) continue;
            return true;
        }
        return false;
    }
}

