/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom.drop;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraftforge.event.world.BlockEvent;
import ru.poopycoders.improvedextraction.custom.drop.types.IDrop;
import ru.poopycoders.improvedextraction.utils.Counter;

public class CustomDrop {
    private Block block;
    private int maxDropCount = 0;
    private int blockMeta;
    private ArrayList<IDrop> newDrops = new ArrayList();

    public CustomDrop(Block block, int blockMeta) {
        this.block = block;
        this.blockMeta = blockMeta;
    }

    public CustomDrop(Block block) {
        this(block, -1);
    }

    public void addDrop(IDrop drop) {
        this.newDrops.add(drop);
    }

    public void setMaxDropCount(int maxDropCount) {
        this.maxDropCount = maxDropCount;
    }

    public Block getBlock() {
        return this.block;
    }

    public ArrayList<IDrop> getDrops() {
        return this.newDrops;
    }

    public boolean isSuitable(BlockEvent.HarvestDropsEvent event) {
        return true;
    }

    public void apply(BlockEvent.HarvestDropsEvent event) {
        Counter dropCounter = new Counter();
        for (IDrop drop : this.newDrops) {
            drop.apply(event, dropCounter);
            if (this.maxDropCount <= 0 || dropCounter.get() < this.maxDropCount) continue;
            break;
        }
    }

    public int getBlockMeta() {
        return this.blockMeta;
    }
}

