/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ru.poopycoders.improvedextraction.ImprovedExtraction;
import ru.poopycoders.improvedextraction.custom.resources.CrystalType;
import ru.poopycoders.improvedextraction.custom.resources.MetalType;
import ru.poopycoders.improvedextraction.custom.resources.RockType;
import ru.poopycoders.improvedextraction.custom.resources.ShardType;
import ru.poopycoders.improvedextraction.custom.resources.interfaces.IResourceType;
import ru.poopycoders.improvedextraction.items.ItemCuttingDisk;
import ru.poopycoders.improvedextraction.items.ItemCuttingTool;
import ru.poopycoders.improvedextraction.items.ItemFishSkeleton;
import ru.poopycoders.improvedextraction.items.ItemOreCluster;
import ru.poopycoders.improvedextraction.items.ItemOreFragment;
import ru.poopycoders.improvedextraction.items.ItemPortableStacker;
import ru.poopycoders.improvedextraction.items.ItemRawCrystal;
import ru.poopycoders.improvedextraction.items.ItemRock;
import ru.poopycoders.improvedextraction.items.ItemShard;
import ru.poopycoders.improvedextraction.items.ItemSmallRock;
import ru.poopycoders.improvedextraction.items.types.ModItemAxe;
import ru.poopycoders.improvedextraction.items.types.ModItemHoe;
import ru.poopycoders.improvedextraction.items.types.ModItemPickaxe;
import ru.poopycoders.improvedextraction.items.types.ModItemSpade;
import ru.poopycoders.improvedextraction.items.types.ModItemSword;

public class ModItems {
    private static final Item.ToolMaterial finiteToolMaterial = EnumHelper.addToolMaterial((String)"improvedextraction:finite", (int)6, (int)2154, (float)14.0f, (float)9.0f, (int)17);
    public static ItemRock itemRock = new ItemRock();
    public static ItemSmallRock itemSmallRock = new ItemSmallRock();
    public static ItemFishSkeleton itemFishSkeleton = new ItemFishSkeleton();
    public static ItemOreFragment itemOreFragment = new ItemOreFragment();
    public static ItemOreCluster itemOreCluster = new ItemOreCluster();
    public static ItemRawCrystal itemRawCrystal = new ItemRawCrystal();
    public static ItemCuttingTool itemCuttingTool = new ItemCuttingTool();
    public static ItemCuttingDisk itemCuttingDisk = new ItemCuttingDisk();
    public static ItemShard itemShard = new ItemShard();
    public static Item itemFiniteIngot = new Item();
    public static ModItemAxe itemFiniteAxe = new ModItemAxe(finiteToolMaterial, 10.0f, -3.0f);
    public static ModItemHoe itemFiniteHoe = new ModItemHoe(finiteToolMaterial);
    public static ModItemPickaxe itemFinitePickaxe = new ModItemPickaxe(finiteToolMaterial);
    public static ModItemSpade itemFiniteSpade = new ModItemSpade(finiteToolMaterial);
    public static ModItemSword itemFiniteSword = new ModItemSword(finiteToolMaterial);
    public static ItemPortableStacker itemPortableStacker = new ItemPortableStacker();

    public static void register() {
        ModItems.registerItem(itemRock, "rock");
        ModItems.registerItem(itemSmallRock, "small_rock");
        ModItems.registerItem(itemFishSkeleton, "fish_skeleton", "bone");
        ModItems.registerItem(itemOreFragment, "ore_fragment");
        ModItems.registerItem(itemOreCluster, "ore_cluster");
        ModItems.registerItem(itemRawCrystal, "raw_crystal");
        ModItems.registerItem((Item)itemCuttingTool, "cutting_tool");
        ModItems.registerItem(itemCuttingDisk, "cutting_disk");
        ModItems.registerItem(itemShard, "shard");
        ModItems.registerItem(itemFiniteIngot, "finite_ingot", "ingotFinite");
        ModItems.registerItem((Item)itemFiniteAxe, "finite_axe");
        ModItems.registerItem((Item)itemFiniteHoe, "finite_hoe");
        ModItems.registerItem((Item)itemFinitePickaxe, "finite_pickaxe");
        ModItems.registerItem((Item)itemFiniteSpade, "finite_spade");
        ModItems.registerItem((Item)itemFiniteSword, "finite_sword");
        ModItems.registerItem(itemPortableStacker, "portable_stacker");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        ModItems.registerItemRenderWithMeta(itemRock, RockType.values());
        ModItems.registerItemRenderWithMeta(itemOreFragment, MetalType.values());
        ModItems.registerItemRenderWithMeta(itemOreCluster, MetalType.values());
        ModItems.registerItemRenderWithMetaAndColor(itemRawCrystal, CrystalType.values());
        ModItems.registerItemRenderWithMeta(itemShard, ShardType.values());
        ModItems.registerItemRender(itemSmallRock);
        ModItems.registerItemRender(itemFishSkeleton);
        ModItems.registerItemRender((Item)itemCuttingTool);
        ModItems.registerItemRender(itemCuttingDisk);
        ModItems.registerItemRender(itemFiniteIngot);
        ModItems.registerItemRender((Item)itemFiniteAxe);
        ModItems.registerItemRender((Item)itemFiniteHoe);
        ModItems.registerItemRender((Item)itemFinitePickaxe);
        ModItems.registerItemRender((Item)itemFiniteSpade);
        ModItems.registerItemRender((Item)itemFiniteSword);
        ModItems.registerItemRender(itemPortableStacker);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemColors() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 1) {
                byte type;
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RockType") && (type = stack.func_77978_p().func_74771_c("RockType")) < RockType.values().length) {
                    return RockType.byMeta(type).getColor();
                }
                return RockType.STONE.getColor();
            }
            return -1;
        }, new Item[]{itemOreFragment});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                if (stack.func_77952_i() < CrystalType.values().length) {
                    return CrystalType.byMeta(stack.func_77952_i()).getColor();
                }
                return RockType.STONE.getColor();
            }
            return -1;
        }, new Item[]{itemRawCrystal});
    }

    private static void registerItem(Item item, String name) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)item.func_77655_b(name).setRegistryName("improvedextraction", name)).func_77637_a((CreativeTabs)ImprovedExtraction.creativeTab));
    }

    private static void registerItem(Item item, String name, String oreDictionaryName) {
        ModItems.registerItem(item, name);
        OreDictionary.registerOre((String)oreDictionaryName, (Item)item);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRender(Item item, int meta, String fileName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(fileName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRenderWithMeta(Item item, IResourceType[] types) {
        ResourceLocation[] resourceLocations = new ResourceLocation[types.length];
        for (IResourceType type : types) {
            ModItems.registerItemRender(item, type.getMeta(), item.getRegistryName() + "_" + type.func_176610_l());
            resourceLocations[type.getMeta()] = new ResourceLocation(item.getRegistryName() + "_" + type.func_176610_l());
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])resourceLocations);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemRenderWithMetaAndColor(Item item, IResourceType[] types) {
        ResourceLocation[] resourceLocations = new ResourceLocation[types.length];
        for (IResourceType type : types) {
            ModItems.registerItemRender(item, type.getMeta(), item.getRegistryName().toString());
            resourceLocations[type.getMeta()] = new ResourceLocation(item.getRegistryName().toString());
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])resourceLocations);
    }
}

