/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.custom;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ru.poopycoders.improvedextraction.ImprovedExtraction;
import ru.poopycoders.improvedextraction.blocks.BlockAutoCuttingTable;
import ru.poopycoders.improvedextraction.blocks.BlockCustomCobblestone;
import ru.poopycoders.improvedextraction.blocks.BlockCuttingTable;
import ru.poopycoders.improvedextraction.blocks.BlockFiniteOre;
import ru.poopycoders.improvedextraction.blocks.items.ItemCustomCobblestone;
import ru.poopycoders.improvedextraction.blocks.items.ModItemBlock;

public class ModBlocks {
    public static BlockCustomCobblestone customCobblestone = new BlockCustomCobblestone();
    public static BlockCuttingTable cuttingTable = new BlockCuttingTable();
    public static BlockAutoCuttingTable autoCuttingTable = new BlockAutoCuttingTable();
    public static BlockFiniteOre finiteOre = new BlockFiniteOre();
    public static Block finiteBlock = new Block(Material.field_151573_f);

    public static void register() {
        ModBlocks.registerBlock(customCobblestone, "custom_cobblestone", new ItemCustomCobblestone(customCobblestone));
        ModBlocks.registerBlock(cuttingTable, "cutting_table", new ModItemBlock(cuttingTable));
        ModBlocks.registerBlock((Block)autoCuttingTable, "auto_cutting_table", new ModItemBlock((Block)autoCuttingTable));
        ModBlocks.registerBlock(finiteOre, "finite_ore", new ModItemBlock(finiteOre));
        ModBlocks.registerBlock(finiteBlock, "finite_block", new ModItemBlock(finiteBlock));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        ResourceLocation[] resourceLocations = new ResourceLocation[BlockCustomCobblestone.EnumType.values().length];
        for (BlockCustomCobblestone.EnumType type : BlockCustomCobblestone.EnumType.values()) {
            ModBlocks.registerBlockRender(customCobblestone, type.getMeta(), customCobblestone.getRegistryName() + "_" + type.func_176610_l());
            resourceLocations[type.getMeta()] = new ResourceLocation(customCobblestone.getRegistryName() + "_" + type.func_176610_l());
        }
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)customCobblestone), (ResourceLocation[])resourceLocations);
        ModBlocks.registerBlockRender(cuttingTable);
        ModBlocks.registerBlockRender((Block)autoCuttingTable);
        ModBlocks.registerBlockRender(finiteOre);
        ModBlocks.registerBlockRender(finiteBlock);
    }

    private static void registerBlock(Block block, String name, ItemBlock itemBlock) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)((Block)block.func_149663_c(name).setRegistryName("improvedextraction", name)).func_149647_a((CreativeTabs)ImprovedExtraction.creativeTab));
        ForgeRegistries.ITEMS.register(itemBlock.setRegistryName("improvedextraction", name));
    }

    private static void registerBlock(Block block, String name, ItemBlock itemBlock, String oreDictionaryName) {
        ModBlocks.registerBlock(block, name, itemBlock);
        OreDictionary.registerOre((String)oreDictionaryName, (Block)block);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerBlockRender(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("improvedextraction", block.func_149739_a().substring(5)), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerBlockRender(Block block, int meta, String fileName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(fileName, "inventory"));
    }
}

