/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import ru.poopycoders.improvedextraction.custom.resources.CrystalType;
import ru.poopycoders.improvedextraction.custom.resources.GemType;
import ru.poopycoders.improvedextraction.custom.resources.MetalType;
import ru.poopycoders.improvedextraction.custom.resources.RockType;

public class ModConfig {
    public static Configuration config;
    public static List<String> black_list;
    public static boolean generateOres;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("improvedextraction")) {
            ModConfig.syncConfig();
        }
    }

    public static void init(File file) {
        config = new Configuration(file);
        ModConfig.syncConfig();
    }

    public static void syncConfig() {
        String metalCategory = "metal_types";
        config.addCustomCategoryComment(metalCategory, "Control of each of the metal types");
        for (MetalType metalType : MetalType.values()) {
            boolean enabled = config.getBoolean(metalType.func_176610_l().toLowerCase(), metalCategory, true, "Will the drop from " + metalType.getAliases().get()[0] + " ores be changed");
            metalType.setEnabled(enabled);
        }
        String rockCategory = "rock_types";
        config.addCustomCategoryComment(rockCategory, "Control of each of the rock types");
        for (RockType rockType : RockType.values()) {
            boolean enabled = config.getBoolean(rockType.func_176610_l().toLowerCase(), rockCategory, true, "Will the drop from " + rockType.func_176610_l().toLowerCase() + " ores be changed");
            rockType.setEnabled(enabled);
        }
        String crystalCategory = "crystal_types";
        config.addCustomCategoryComment(crystalCategory, "Control of each of the crystal types");
        for (CrystalType crystalType : CrystalType.values()) {
            boolean enabled = config.getBoolean(crystalType.func_176610_l().toLowerCase(), crystalCategory, true, "Will the drop from " + crystalType.getAliases().get()[0] + " ores be changed");
            crystalType.setEnabled(enabled);
        }
        String gemCategory = "gem_types";
        config.addCustomCategoryComment(gemCategory, "Control of each of the gem types");
        for (GemType gemType : GemType.values()) {
            boolean enabled = config.getBoolean(gemType.func_176610_l().toLowerCase(), gemCategory, true, "Will the drop from " + gemType.func_176610_l().toLowerCase() + " ores be changed");
            gemType.setEnabled(enabled);
        }
        String settingsCategory = "global_settings";
        config.addCustomCategoryComment(settingsCategory, "Global mod settings");
        String[] list = config.getStringList("black_list", settingsCategory, new String[]{"modid:example_ore:0"}, "Block list, drop from which will not be changed \nFormat: <modid>:<id>:<meta> or <modid>:<id>:<meta> for all metas");
        black_list = new ArrayList<String>();
        try {
            for (String line : list) {
                String[] s = line.split(":");
                String ls = s[0] + ":" + s[1] + ":" + (s.length > 1 ? s[2] : "-1");
                black_list.add(ls);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        generateOres = config.getBoolean("generate_ores", settingsCategory, true, "Should Improved Extraction generate ores.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        generateOres = true;
    }
}

