/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedextraction.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import ru.poopycoders.improvedextraction.blocks.items.IMetaBlockName;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.IItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.ItemContainer;
import ru.poopycoders.improvedextraction.custom.drop.itemcontainers.OreDictionaryItemContainer;
import ru.poopycoders.improvedextraction.utils.Aliases;

public class BlockCustomCobblestone
extends Block
implements IMetaBlockName {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    public static final int[] randomCount = new int[]{2, 2, 3, 3, 4};

    public BlockCustomCobblestone() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.GRANITE)));
        this.func_149711_c(2.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_149708_J() == tab) {
            for (int i = 0; i < EnumType.values().length; ++i) {
                list.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return EnumType.byMeta(stack.func_77952_i()).func_176610_l();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer entityPlayer) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos).func_177229_b(TYPE) == EnumType.NETHER && facing == EnumFacing.UP;
    }

    public static enum EnumType implements IStringSerializable
    {
        GRANITE(0, "granite", new Aliases("cobblestone", "cobblestoneGranite"), new ItemContainer(Blocks.field_150348_b, 1)),
        DIORITE(1, "diorite", new Aliases("cobblestone", "cobblestoneDiorite"), new ItemContainer(Blocks.field_150348_b, 3)),
        ANDESITE(2, "andesite", new Aliases("cobblestone", "cobblestoneAndesite"), new ItemContainer(Blocks.field_150348_b, 5)),
        NETHER(3, "nether", new Aliases("cobblestoneNetherrack", "cobblestoneNether"), new ItemContainer(Blocks.field_150424_aL)),
        END(4, "end", new Aliases("cobblestoneEnd", "cobblestoneEndstone"), new ItemContainer(Blocks.field_150377_bs)),
        BASALT(5, "basalt", new Aliases("cobblestoneBasalt"), new OreDictionaryItemContainer("stoneBasalt")),
        MARBLE(6, "marble", new Aliases("cobblestoneMarble"), new OreDictionaryItemContainer("stoneMarble"), new OreDictionaryItemContainer("stoneMarmor")),
        LIMESTONE(7, "limestone", new Aliases("cobblestoneLimestone"), new OreDictionaryItemContainer("stoneLimestone"));

        private final int meta;
        private final String name;
        private Aliases oreDictionaryNames;
        private IItemContainer[] smeltingItemContainers;

        private EnumType(int meta, String name, Aliases oreDictionaryNames, IItemContainer ... smeltingItemContainers) {
            this.meta = meta;
            this.name = name;
            this.oreDictionaryNames = oreDictionaryNames;
            this.smeltingItemContainers = smeltingItemContainers;
        }

        private EnumType(int meta, String name, IItemContainer ... smeltingItemContainers) {
            this(meta, name, new Aliases(), smeltingItemContainers);
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMeta(int meta) {
            if (meta < 0 || meta >= EnumType.values().length) {
                meta = 0;
            }
            return EnumType.values()[meta];
        }

        public IItemContainer[] getSmeltingItemContainers() {
            return this.smeltingItemContainers;
        }

        public Aliases getOreDictionaryNames() {
            return this.oreDictionaryNames;
        }
    }
}

