/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityEffectsBlock
extends TileEntityElectricBlock
implements IActiveState {
    private SoundEvent soundEvent;
    @SideOnly(value=Side.CLIENT)
    private ISound activeSound;
    private int playSoundCooldown = 0;
    private int rapidChangeThreshold = 10;
    protected boolean isActive;
    private long lastActive = -1L;
    private final int RECENT_THRESHOLD = 100;

    public TileEntityEffectsBlock(String sound, String name, double baseMaxEnergy) {
        super(name, baseMaxEnergy);
        if (!sound.equals("null")) {
            this.soundEvent = new SoundEvent(new ResourceLocation("mekanism", "tile." + sound));
        }
    }

    public TileEntityEffectsBlock(String sound, String name, double baseMaxEnergy, int rapidChangeThreshold) {
        this(sound, name, baseMaxEnergy);
        this.rapidChangeThreshold = rapidChangeThreshold;
    }

    protected float getInitialVolume() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    protected void setSoundEvent(SoundEvent event) {
        this.soundEvent = event;
        SoundHandler.stopTileSound(this.func_174877_v());
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (!MekanismConfig.current().client.enableMachineSounds.val()) {
            return;
        }
        if (this.soundEvent == null) {
            if (this instanceof TileEntityFactory) {
                this.setSoundEvent(((TileEntityFactory)this).getRecipeType().getSound());
            }
            return;
        }
        if (this.getActive() && !this.func_145837_r()) {
            if (--this.playSoundCooldown > 0) {
                return;
            }
            if (!(this.isFullyMuffled() || this.activeSound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c(this.activeSound))) {
                this.activeSound = SoundHandler.startTileSound(this.soundEvent.func_187503_a(), this.getInitialVolume(), this.func_174877_v());
            }
            this.playSoundCooldown = 20;
        } else {
            long downtime = this.field_145850_b.func_82737_E() - this.lastActive;
            if (this.activeSound != null && downtime > (long)this.rapidChangeThreshold) {
                SoundHandler.stopTileSound(this.func_174877_v());
                this.activeSound = null;
                this.playSoundCooldown = 0;
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @Override
    public void onUpdate() {
        long updateDiff;
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
        if (this.field_145850_b.field_72995_K && !this.isActive && this.lastActive > 0L && (updateDiff = this.field_145850_b.func_82737_E() - this.lastActive) > 100L) {
            MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            this.lastActive = -1L;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        boolean stateChange;
        boolean bl = stateChange = this.isActive != active;
        if (stateChange) {
            this.isActive = active;
            Mekanism.packetHandler.sendUpdatePacket(this);
        }
    }

    @Override
    public boolean wasActiveRecently() {
        return this.isActive || this.lastActive > 0L && this.field_145850_b.func_82737_E() - this.lastActive < 100L;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            boolean newActive = dataStream.readBoolean();
            boolean stateChange = newActive != this.isActive;
            this.isActive = newActive;
            if (stateChange && !this.isActive) {
                this.lastActive = this.field_145850_b.func_82737_E();
            } else if (stateChange && this.isActive) {
                if (this.lastActive == -1L) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
                this.lastActive = -1L;
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        return nbtTags;
    }

    private boolean isFullyMuffled() {
        if (!(this instanceof IUpgradeTile)) {
            return false;
        }
        IUpgradeTile tile = (IUpgradeTile)((Object)this);
        if (tile.getComponent().supports(Upgrade.MUFFLING)) {
            return tile.getComponent().getUpgrades(Upgrade.MUFFLING) == Upgrade.MUFFLING.getMax();
        }
        return false;
    }
}

